/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.util.logging.logging;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.xqhs.util.logging.DisplayEntity;
import net.xqhs.util.logging.LoggerSimple;
import net.xqhs.util.logging.ReportingEntity;
import net.xqhs.util.logging.UnitComponent;
import net.xqhs.util.logging.logging.LogDebug;
import net.xqhs.util.logging.logging.LogWrapper;

public class Logging {
    public static final LogWrapper.LoggerType defaultLoggerWrapper = LogWrapper.LoggerType.LOG4J;
    public static Character AWESOME_SEPARATOR = new Character('\u001e');
    protected static Map<String, Logging> logs = Collections.synchronizedMap(new HashMap());
    protected static Map<String, String> parents = new HashMap<String, String>();
    protected static UnitComponent masterLog = new UnitComponent();
    protected static String masterLogName = "M-log";
    protected LogWrapper logger = null;
    protected String wrapperClass = null;
    protected LogWrapper.LoggerType wrapperType = null;
    protected String name = null;
    protected LoggerSimple.Level logLevel = LoggerSimple.Level.ALL;
    protected ByteArrayOutputStream logOutput = null;
    protected ByteArrayOutputStream logOutputStamped = null;
    protected long logSize = 0L;
    protected DisplayEntity logDisplay = null;
    protected ReportingEntity externalReporter = null;
    protected Timer logTimer = null;
    protected long logUpdateDelay = 250L;
    protected long reportUpdateDelay = 2000L;
    protected long timeToNextReport = 0L;
    protected int lastUpdatedSize = 0;

    public static UnitComponent getMasterLogging() {
        return masterLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogWrapper getLogger(String string, String string2, DisplayEntity displayEntity, ReportingEntity reportingEntity, boolean bl, String string3, LoggerSimple.Level level) throws ClassNotFoundException {
        boolean bl2 = false;
        int n = -1;
        if (masterLog == null || masterLog.getUnitName() == null) {
            masterLog.setUnitName(masterLogName);
            masterLog.lock();
        }
        if (string == null) {
            throw new IllegalArgumentException("log name cannot be null. Use Unit.DEFAULT_UNIT_NAME for the default name.");
        }
        masterLog.dbg(LogDebug.LogDebugItem.D_LOG_MANAGEMENT, "required: [" + string + "]" + (bl ? "[new]" : "") + "; existing: [" + logs.size() + "]: [" + logs + "]", new Object[0]);
        Logging logging = new Logging(string, string3, displayEntity, reportingEntity);
        Logging logging2 = null;
        Map<String, Logging> map = logs;
        synchronized (map) {
            if (logs.containsKey(string)) {
                if (bl) {
                    bl2 = true;
                } else {
                    logging2 = logs.get(string);
                }
            } else {
                logs.put(string, logging);
                parents.put(string, string2);
                n = logs.size();
            }
        }
        if (bl2) {
            logging.doexit();
            throw new IllegalArgumentException("log name already present [" + string + "]");
        }
        if (logging2 != null) {
            logging.doexit();
            logging = logging2;
        }
        if (level != null) {
            logging.logger.setLevel(level);
        }
        logging.logger.l(LoggerSimple.Level.TRACE, "new log (count now [" + n + "]).");
        return logging.getLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLoggerOutput(String string, boolean bl) {
        Logging logging = null;
        Map<String, Logging> map = logs;
        synchronized (map) {
            logging = logs.get(string);
        }
        if (logging == null) {
            throw new IllegalArgumentException("log not present [" + string + "]");
        }
        if (bl) {
            return logging.logOutput.toString();
        }
        return logging.logOutputStamped.toString();
    }

    public static void exitLogger(String string) {
        Logging.exitLogger(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exitLogger(String string, boolean bl) {
        boolean bl2 = false;
        Logging logging = null;
        int n = -1;
        Vector<String> vector = new Vector<String>();
        Map<String, Logging> map = logs;
        synchronized (map) {
            if (!logs.containsKey(string)) {
                bl2 = true;
            } else {
                for (Map.Entry<String, String> entry : parents.entrySet()) {
                    if (!string.equals(entry.getValue())) continue;
                    vector.add(entry.getKey());
                }
                logging = logs.get(string);
                logs.remove(string);
                parents.remove(string);
                n = logs.size();
            }
        }
        if (bl2 || logging == null) {
            throw new IllegalArgumentException("log not present [" + string + "]");
        }
        logging.getLog().l(LoggerSimple.Level.TRACE, "log out (logs remaining [" + n + "]).");
        for (String string2 : vector) {
            Logging.exitLogger(string2, bl);
        }
        if (bl) {
            logging.updateLogText();
        }
        logging.doexit();
        if (n == 1 && masterLog != null) {
            masterLog.doExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetLogging() {
        Map<String, Logging> map = logs;
        synchronized (map) {
            logs.clear();
            parents.clear();
        }
        if (masterLog != null) {
            masterLog.lf("--------logs cleared-------------", new Object[0]);
            masterLog.doExit();
        }
    }

    protected Logging(String string, String string2, DisplayEntity displayEntity, ReportingEntity reportingEntity) throws ClassNotFoundException {
        Object object;
        Object object22;
        this.name = string;
        this.logOutput = new ByteArrayOutputStream();
        this.logOutputStamped = new ByteArrayOutputStream();
        if (string2 == null) {
            this.wrapperType = defaultLoggerWrapper;
            this.wrapperClass = defaultLoggerWrapper.getClassName();
        } else {
            for (Object object22 : LogWrapper.LoggerType.values()) {
                if (!string2.equals(object22.getClassName())) continue;
                this.wrapperType = object22;
            }
            this.wrapperClass = string2;
        }
        Object object3 = null;
        object3 = new ClassLoader(this.getClass().getClassLoader()){};
        try {
            object = ((ClassLoader)object3).loadClass(this.wrapperClass).getConstructor(String.class);
            this.logger = (LogWrapper)((Constructor)object).newInstance(this.name);
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Wrapper class cannot be instantiated.", exception);
        }
        if (this.logger == null) {
            throw new IllegalStateException();
        }
        this.logger.setLevel(this.logLevel);
        object = null;
        String string3 = null;
        object22 = null;
        switch (this.wrapperType) {
            case LOG4J: {
                object = "%-5p \t %m%n";
                string3 = AWESOME_SEPARATOR + "%d{HH:mm:ss:SSSS} %-5p [" + string + "]:\t %m" + AWESOME_SEPARATOR;
                object22 = "%-5p [" + string + "]:\t %m%n";
                break;
            }
        }
        this.logDisplay = displayEntity;
        this.externalReporter = reportingEntity;
        if (this.logDisplay != null) {
            this.logger.addDestination((String)object, this.logOutput);
        }
        if (this.externalReporter != null) {
            this.logger.addDestination(string3, this.logOutputStamped);
        }
        this.logger.addDestination((String)object22, System.out);
        if (this.logDisplay != null || this.externalReporter != null) {
            this.logTimer = new Timer();
            this.logTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Logging.this.updateLogText();
                }
            }, 0L, this.logUpdateDelay);
        }
    }

    protected LogWrapper getLog() {
        return this.logger;
    }

    protected void updateLogText() {
        int n = this.logOutput.size();
        if (this.logDisplay != null && this.logSize != (long)n) {
            this.logDisplay.output(this.logOutput.toString());
            this.logSize = n;
        }
        this.timeToNextReport -= this.logUpdateDelay;
        if (this.timeToNextReport <= 0L) {
            this.timeToNextReport = this.reportUpdateDelay;
            this.updateReport();
        }
    }

    protected void updateReport() {
        byte[] byArray;
        byte[] byArray2;
        int n = this.logOutputStamped.size();
        if (this.externalReporter != null && n != this.lastUpdatedSize && this.externalReporter.report(new String(byArray2 = Arrays.copyOfRange(byArray = this.logOutputStamped.toByteArray(), this.lastUpdatedSize, n)).trim())) {
            this.lastUpdatedSize = n;
        }
    }

    protected void doexit() {
        if (this.logTimer != null) {
            this.logTimer.cancel();
        }
        this.logger.exit();
    }
}

