/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.util.logging;

import net.xqhs.util.config.Config;
import net.xqhs.util.logging.Debug;
import net.xqhs.util.logging.DisplayEntity;
import net.xqhs.util.logging.LoggerSimple;
import net.xqhs.util.logging.ReportingEntity;
import net.xqhs.util.logging.UnitLinkData;
import net.xqhs.util.logging.logging.LogWrapper;
import net.xqhs.util.logging.logging.Logging;

public class Unit
extends Config {
    public static final String DEFAULT_UNIT_NAME = "theDefaulUnitName";
    public static final LoggerSimple.Level DEFAULT_LEVEL = LoggerSimple.Level.ALL;
    String unitName = null;
    String logName = null;
    boolean ensureNew = false;
    LoggerSimple.Level level = null;
    DisplayEntity display = null;
    ReportingEntity reporter = null;
    LogWrapper.LoggerType loggerWrapperType = null;
    String loggerWrapperClass = null;
    UnitLinkData linkData = new UnitLinkData();
    LogWrapper log = null;

    protected String getDefaultUnitName() {
        return DEFAULT_UNIT_NAME;
    }

    public boolean lockedR() {
        try {
            super.locked();
        }
        catch (Config.ConfigLockedException configLockedException) {
            this.le(configLockedException.toString(), new Object[0]);
            return true;
        }
        return false;
    }

    public Unit lock() {
        if (this.unitName == null || this.logName == null) {
            this.setUnitName(this.unitName);
        }
        super.lock();
        if (this.unitName != null && this.logName != null) {
            try {
                this.log = Logging.getLogger(this.logName, this.linkData.parentLogName, this.display, this.reporter, this.ensureNew, this.loggerWrapperClass, this.level);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Failed to instantiate logging wrapper class.", classNotFoundException);
            }
        }
        return this;
    }

    public Unit setUnitName(String string) {
        return this.setUnitName(string, false, false, false);
    }

    public Unit setUnitName(String string, boolean bl, boolean bl2) {
        return this.setUnitName(string, true, bl, bl2);
    }

    private Unit setUnitName(String string, boolean bl, boolean bl2, boolean bl3) {
        if (this.lockedR()) {
            return this;
        }
        this.unitName = string;
        if (this.unitName == null && !DEFAULT_UNIT_NAME.equals(this.getDefaultUnitName())) {
            this.unitName = this.getDefaultUnitName();
        }
        this.logName = DEFAULT_UNIT_NAME.equals(this.unitName) ? (this.unitName = this.makeClassName(bl3)) : (bl ? (bl2 ? this.unitName + this.makeClassName(bl3) : this.makeClassName(bl3) + this.unitName) : this.unitName);
        if (this.logName != null && this.level == null) {
            this.setLogLevel(DEFAULT_LEVEL);
        }
        return this;
    }

    private String makeClassName(boolean bl) {
        return bl ? ((Object)((Object)this)).getClass().getCanonicalName() : ((Object)((Object)this)).getClass().getSimpleName();
    }

    public Unit setLogEnsureNew() {
        if (this.lockedR()) {
            return this;
        }
        this.ensureNew = true;
        return this;
    }

    public Unit setLoggerType(LogWrapper.LoggerType loggerType) {
        if (loggerType == null) {
            throw new IllegalArgumentException("Given logger type is null");
        }
        return this.setLoggerTypeClass(loggerType, null);
    }

    public Unit setLoggerClass(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Given class is null");
        }
        return this.setLoggerTypeClass(null, string);
    }

    protected Unit setLoggerTypeClass(LogWrapper.LoggerType loggerType, String string) {
        if (this.lockedR()) {
            return this;
        }
        if (loggerType != null && string != null) {
            throw new IllegalArgumentException("cannot set the logger type and the class name at the same time.");
        }
        if (loggerType != null) {
            this.loggerWrapperType = loggerType;
            if (this.loggerWrapperType != LogWrapper.LoggerType.OTHER) {
                this.loggerWrapperClass = loggerType.getClassName();
            }
        }
        if (string != null) {
            this.loggerWrapperClass = string;
            for (LogWrapper.LoggerType loggerType2 : LogWrapper.LoggerType.values()) {
                if (!string.equals(loggerType2.getClassName())) continue;
                this.loggerWrapperType = loggerType2;
            }
            this.loggerWrapperType = LogWrapper.LoggerType.OTHER;
        }
        return this;
    }

    public Unit setLogLevel(LoggerSimple.Level level) {
        this.level = level;
        return this;
    }

    public Unit setLink(String string) {
        return this.setLink(new UnitLinkData().setparentLogName(string));
    }

    public Unit setLink(UnitLinkData unitLinkData) {
        if (this.lockedR()) {
            return this;
        }
        this.linkData = unitLinkData;
        return this;
    }

    public Unit setLogDisplay(DisplayEntity displayEntity) {
        this.display = displayEntity;
        return this;
    }

    public Unit setLogReporter(ReportingEntity reportingEntity) {
        this.reporter = reportingEntity;
        return this;
    }

    protected String getUnitName() {
        return this.unitName;
    }

    protected void doExit() {
        if (this.log != null && this.logName != null) {
            Logging.exitLogger(this.logName);
            this.log = null;
            this.logName = null;
        }
        this.unitName = null;
    }

    protected void le(String string, Object ... objectArray) {
        this.l(LoggerSimple.Level.ERROR, string, objectArray);
    }

    protected void lw(String string, Object ... objectArray) {
        this.l(LoggerSimple.Level.WARN, string, objectArray);
    }

    protected void li(String string, Object ... objectArray) {
        this.l(LoggerSimple.Level.INFO, string, objectArray);
    }

    protected void lf(String string, Object ... objectArray) {
        this.l(LoggerSimple.Level.TRACE, string, objectArray);
    }

    protected Object lr(Object object) {
        return this.lr(object, null, new Object[0]);
    }

    protected Object lr(Object object, String string, Object ... objectArray) {
        this.lf("[" + (object != null ? object.toString() : "null") + "]" + (string != null ? ":[" + string + "]" : ""), new Object[0]);
        return object;
    }

    protected void dbg(Debug.DebugItem debugItem, String string, Object ... objectArray) {
        if (debugItem.toBool()) {
            this.lf(string, new Object[0]);
        }
    }

    protected void l(LoggerSimple.Level level, String string, Object ... objectArray) {
        this.ensureLocked();
        if (this.log != null && level.displayWith(this.level)) {
            this.log.l(level, Unit.compose(string, objectArray));
        }
    }

    protected static String compose(String string, Object[] objectArray) {
        int n;
        String[] stringArray = string.split("\\[\\]", objectArray.length + 1);
        String string2 = stringArray[0];
        for (n = 0; n < stringArray.length - 1; ++n) {
            string2 = string2 + "[" + objectArray[n] + "]";
            string2 = string2 + stringArray[n + 1];
        }
        for (n = stringArray.length - 1; n < objectArray.length; ++n) {
            string2 = string2 + "[" + objectArray[n] + "]";
        }
        return string2;
    }
}

