/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gitlab4j.models.Constants;
import org.gitlab4j.models.GitLabForm;
import org.gitlab4j.models.utils.ISO8601;
import org.gitlab4j.models.utils.JacksonJsonEnumHelper;

public class IssueFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> iids;
    private Constants.IssueState state;
    private List<String> in;
    private List<String> labels;
    private String milestone;
    private Constants.IssueScope scope;
    private Long authorId;
    private Long assigneeId;
    private String myReactionEmoji;
    private Constants.IssueOrderBy orderBy;
    private Constants.SortOrder sort;
    private String search;
    private Date createdAfter;
    private Date createdBefore;
    private Date updatedAfter;
    private Date updatedBefore;
    private String iterationTitle;
    private Map<IssueField, Object> not;

    public List<String> getIids() {
        return this.iids;
    }

    public void setIids(List<String> iids) {
        this.iids = iids;
    }

    public Constants.IssueState getState() {
        return this.state;
    }

    public void setState(Constants.IssueState state) {
        this.state = state;
    }

    public List<String> getIn() {
        return this.in;
    }

    public void setIn(List<String> in) {
        this.in = in;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String milestone) {
        this.milestone = milestone;
    }

    public Constants.IssueScope getScope() {
        return this.scope;
    }

    public void setScope(Constants.IssueScope scope) {
        this.scope = scope;
    }

    public Long getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(Long authorId) {
        this.authorId = authorId;
    }

    public Long getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(Long assigneeId) {
        this.assigneeId = assigneeId;
    }

    public String getMyReactionEmoji() {
        return this.myReactionEmoji;
    }

    public void setMyReactionEmoji(String myReactionEmoji) {
        this.myReactionEmoji = myReactionEmoji;
    }

    public Constants.IssueOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(Constants.IssueOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public Constants.SortOrder getSort() {
        return this.sort;
    }

    public void setSort(Constants.SortOrder sort) {
        this.sort = sort;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public Date getUpdatedAfter() {
        return this.updatedAfter;
    }

    public void setUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
    }

    public Date getUpdatedBefore() {
        return this.updatedBefore;
    }

    public void setUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
    }

    public String getIterationTitle() {
        return this.iterationTitle;
    }

    public void setIterationTitle(String iterationTitle) {
        this.iterationTitle = iterationTitle;
    }

    public Map<IssueField, Object> getNot() {
        return this.not;
    }

    public void setNot(Map<IssueField, Object> not) {
        this.not = not;
    }

    public IssueFilter withIids(List<String> iids) {
        this.iids = iids;
        return this;
    }

    public IssueFilter withState(Constants.IssueState state) {
        this.state = state;
        return this;
    }

    public IssueFilter withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public IssueFilter withMilestone(String milestone) {
        this.milestone = milestone;
        return this;
    }

    public IssueFilter withScope(Constants.IssueScope scope) {
        this.scope = scope;
        return this;
    }

    public IssueFilter withAuthorId(Long authorId) {
        this.authorId = authorId;
        return this;
    }

    public IssueFilter withAssigneeId(Long assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    public IssueFilter withMyReactionEmoji(String myReactionEmoji) {
        this.myReactionEmoji = myReactionEmoji;
        return this;
    }

    public IssueFilter withOrderBy(Constants.IssueOrderBy orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public IssueFilter withSort(Constants.SortOrder sort) {
        this.sort = sort;
        return this;
    }

    public IssueFilter withSearch(String search) {
        this.search = search;
        return this;
    }

    public IssueFilter withCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    public IssueFilter withCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    public IssueFilter withUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
        return this;
    }

    public IssueFilter withUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
        return this;
    }

    public IssueFilter withIterationTitle(String iterationTitle) {
        this.iterationTitle = iterationTitle;
        return this;
    }

    public IssueFilter withNot(Map<IssueField, Object> not) {
        this.not = not;
        return this;
    }

    public IssueFilter withNot(IssueField field, Object value) {
        if (this.not == null) {
            this.not = new LinkedHashMap<IssueField, Object>();
        }
        this.not.put(field, value);
        return this;
    }

    public IssueFilter withoutLabels(String ... labels) {
        return this.withNot(IssueField.LABELS, String.join((CharSequence)",", labels));
    }

    public IssueFilter withoutIids(String ... iids) {
        return this.withNot(IssueField.IIDS, String.join((CharSequence)",", iids));
    }

    public IssueFilter withoutAuthorId(Long authorId) {
        return this.withNot(IssueField.AUTHOR_ID, authorId);
    }

    public IssueFilter withoutAuthorUsername(String authorUsername) {
        return this.withNot(IssueField.AUTHOR_USERNAME, authorUsername);
    }

    public IssueFilter withoutAssigneeId(Long assigneeId) {
        return this.withNot(IssueField.ASSIGNEE_ID, assigneeId);
    }

    public IssueFilter withoutAssigneeUsername(String assigneeUsername) {
        return this.withNot(IssueField.ASSIGNEE_USERNAME, assigneeUsername);
    }

    public IssueFilter withoutIterationId(Long iterationId) {
        return this.withNot(IssueField.ITERATION_ID, iterationId);
    }

    public IssueFilter withoutIterationTitle(String iterationTitle) {
        return this.withNot(IssueField.ITERATION_TITLE, iterationTitle);
    }

    public IssueFilter withoutMilestoneId(Long milestoneId) {
        return this.withNot(IssueField.MILESTONE_ID, milestoneId);
    }

    public IssueFilter withoutMilestone(String milestone) {
        return this.withNot(IssueField.MILESTONE, milestone);
    }

    @JsonIgnore
    public GitLabForm getQueryParams(int page, int perPage) {
        return this.getQueryParams().withParam("page", page).withParam("per_page", perPage);
    }

    @JsonIgnore
    public GitLabForm getQueryParams() {
        return new GitLabForm().withParam("iids", this.iids).withParam("state", (Object)this.state).withParam("labels", this.labels != null ? String.join((CharSequence)",", this.labels) : null).withParam("in", this.in != null ? String.join((CharSequence)",", this.in) : null).withParam("milestone", this.milestone).withParam("scope", (Object)this.scope).withParam("author_id", this.authorId).withParam("assignee_id", this.assigneeId).withParam("my_reaction_emoji", this.myReactionEmoji).withParam("order_by", (Object)this.orderBy).withParam("sort", (Object)this.sort).withParam("search", this.search).withParam("created_after", ISO8601.toString(this.createdAfter, false)).withParam("created_before", ISO8601.toString(this.createdBefore, false)).withParam("updated_after", ISO8601.toString(this.updatedAfter, false)).withParam("updated_before", ISO8601.toString(this.updatedBefore, false)).withParam("iteration_title", this.iterationTitle).withParam("not", this.toStringMap(this.not), false);
    }

    private Map<String, Object> toStringMap(Map<IssueField, Object> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<IssueField, Object> entry : map.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue());
        }
        return result;
    }

    public static enum IssueField {
        ASSIGNEE_ID,
        ASSIGNEE_USERNAME,
        AUTHOR_ID,
        AUTHOR_USERNAME,
        IIDS,
        ITERATION_ID,
        ITERATION_TITLE,
        LABELS,
        MILESTONE,
        MILESTONE_ID;

        private static JacksonJsonEnumHelper<IssueField> enumHelper;

        @JsonCreator
        public static IssueField forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueField>(IssueField.class);
        }
    }
}

