/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Event;

public class EventsApi
extends AbstractApi {
    public EventsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Event> getAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getAuthenticatedUserEvents(action, targetType, before, after, sortOrder, this.getDefaultPerPage()).all();
    }

    public List<Event> getAllAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getAuthenticatedUserEvents(action, targetType, before, after, sortOrder, this.getDefaultPerPage(), Constants.EventScope.ALL).all();
    }

    public List<Event> getAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int page, int perPage) throws GitLabApiException {
        return this.getAuthenticatedUserEvents(action, targetType, before, after, sortOrder, page, perPage, null);
    }

    public List<Event> getAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int page, int perPage, Constants.EventScope scope) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder).withParam("page", page).withParam("per_page", perPage).withParam("scope", scope != null ? scope.toValue().toLowerCase() : null);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "events");
        return (List)response.readEntity((GenericType)new GenericType<List<Event>>(){});
    }

    public Pager<Event> getAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int itemsPerPage) throws GitLabApiException {
        return this.getAuthenticatedUserEvents(action, targetType, before, after, sortOrder, itemsPerPage, null);
    }

    public Pager<Event> getAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int itemsPerPage, Constants.EventScope scope) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder).withParam("scope", scope != null ? scope.toValue().toLowerCase() : null);
        return new Pager<Event>(this, Event.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "events");
    }

    public Stream<Event> getAuthenticatedUserEventsStream(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getAuthenticatedUserEvents(action, targetType, before, after, sortOrder, this.getDefaultPerPage(), null).stream();
    }

    public Stream<Event> getAllAuthenticatedUserEventsStream(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getAuthenticatedUserEvents(action, targetType, before, after, sortOrder, this.getDefaultPerPage(), Constants.EventScope.ALL).stream();
    }

    public List<Event> getUserEvents(Object userIdOrUsername, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getUserEvents(userIdOrUsername, action, targetType, before, after, sortOrder, this.getDefaultPerPage()).all();
    }

    public List<Event> getUserEvents(Object userIdOrUsername, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users", this.getUserIdOrUsername(userIdOrUsername), "events");
        return (List)response.readEntity((GenericType)new GenericType<List<Event>>(){});
    }

    public Pager<Event> getUserEvents(Object userIdOrUsername, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder);
        return new Pager<Event>(this, Event.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users", this.getUserIdOrUsername(userIdOrUsername), "events");
    }

    public Stream<Event> getUserEventsStream(Object userIdOrUsername, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getUserEvents(userIdOrUsername, action, targetType, before, after, sortOrder, this.getDefaultPerPage()).stream();
    }

    public List<Event> getProjectEvents(Object projectIdOrPath, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getProjectEvents(projectIdOrPath, action, targetType, before, after, sortOrder, this.getDefaultPerPage()).all();
    }

    public List<Event> getProjectEvents(Long projectIdOrPath, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "events");
        return (List)response.readEntity((GenericType)new GenericType<List<Event>>(){});
    }

    public Pager<Event> getProjectEvents(Object projectIdOrPath, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder);
        return new Pager<Event>(this, Event.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "events");
    }

    public Stream<Event> getProjectEventsStream(Object projectIdOrPath, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getProjectEvents(projectIdOrPath, action, targetType, before, after, sortOrder, this.getDefaultPerPage()).stream();
    }
}

