/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.systemhooks;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.HookManager;
import org.gitlab4j.api.systemhooks.ProjectSystemHookEvent;
import org.gitlab4j.api.systemhooks.SystemHookEvent;
import org.gitlab4j.api.systemhooks.SystemHookListener;
import org.gitlab4j.api.systemhooks.TeamMemberSystemHookEvent;
import org.gitlab4j.api.utils.HttpRequestUtils;
import org.gitlab4j.api.utils.JacksonJson;

public class SystemHookManager
extends HookManager {
    public static final String SYSTEM_HOOK_EVENT = "System Hook";
    private static final Logger LOG = Logger.getLogger(SystemHookManager.class.getName());
    private final JacksonJson jacksonJson = new JacksonJson();
    private final List<SystemHookListener> systemHookListeners = new CopyOnWriteArrayList<SystemHookListener>();

    public SystemHookManager() {
    }

    public SystemHookManager(String secretToken) {
        super(secretToken);
    }

    @Override
    public void handleEvent(HttpServletRequest request) throws GitLabApiException {
        if (!this.isValidSecretToken(request)) {
            String message = "X-Gitlab-Token mismatch!";
            LOG.warning(message);
            throw new GitLabApiException(message);
        }
        String eventName = request.getHeader("X-Gitlab-Event");
        LOG.info("handleEvent: X-Gitlab-Event=" + eventName);
        if (!SYSTEM_HOOK_EVENT.equals(eventName)) {
            String message = "Unsupported X-Gitlab-Event, event Name=" + eventName;
            LOG.warning(message);
            throw new GitLabApiException(message);
        }
        String errorMessage = null;
        try {
            SystemHookEvent event;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(HttpRequestUtils.getShortRequestDump(SYSTEM_HOOK_EVENT, true, request));
                String postData = HttpRequestUtils.getPostDataAsString(request);
                LOG.fine("Raw POST data:\n" + postData);
                event = this.jacksonJson.unmarshal(SystemHookEvent.class, postData);
                LOG.fine(event.getEventName() + "\n" + this.jacksonJson.marshal(event) + "\n");
            } else {
                InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream());
                event = this.jacksonJson.unmarshal(SystemHookEvent.class, reader);
            }
            this.fireEvent(event);
        }
        catch (JsonParseException jpe) {
            errorMessage = jpe.getMessage();
            LOG.warning("Error parsing JSON data, error=" + errorMessage);
        }
        catch (JsonMappingException jme) {
            errorMessage = jme.getMessage();
            LOG.warning("Error mapping JSON data, error=" + errorMessage);
        }
        catch (IOException ioe) {
            errorMessage = ioe.getMessage();
            LOG.warning("Error reading JSON data, error=" + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            LOG.warning("Unexpected error reading JSON data, error=" + errorMessage);
        }
        if (errorMessage != null) {
            throw new GitLabApiException(errorMessage);
        }
    }

    public void handleEvent(SystemHookEvent event) throws GitLabApiException {
        LOG.info("handleEvent: object_kind=" + event.getEventName());
        this.fireEvent(event);
    }

    public void addListener(SystemHookListener listener) {
        if (!this.systemHookListeners.contains(listener)) {
            this.systemHookListeners.add(listener);
        }
    }

    public void removeListener(SystemHookListener listener) {
        this.systemHookListeners.remove(listener);
    }

    public void fireEvent(SystemHookEvent event) throws GitLabApiException {
        if (event instanceof ProjectSystemHookEvent) {
            this.fireProjectEvent((ProjectSystemHookEvent)event);
        } else if (event instanceof TeamMemberSystemHookEvent) {
            this.fireTeamMemberEvent((TeamMemberSystemHookEvent)event);
        } else {
            String message = "Unsupported event, event_named=" + event.getEventName();
            LOG.warning(message);
            throw new GitLabApiException(message);
        }
    }

    protected void fireProjectEvent(ProjectSystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onProjectEvent(event);
        }
    }

    protected void fireTeamMemberEvent(TeamMemberSystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onTeamMemberEvent(event);
        }
    }
}

