/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Map;
import org.gitlab4j.api.CommitsApi;
import org.gitlab4j.api.GitLabApiClient;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.MergeRequestApi;
import org.gitlab4j.api.NamespaceApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.RepositoryApi;
import org.gitlab4j.api.RepositoryFileApi;
import org.gitlab4j.api.ServicesApi;
import org.gitlab4j.api.SessionApi;
import org.gitlab4j.api.UserApi;
import org.gitlab4j.api.models.Session;

public class GitLabApi {
    GitLabApiClient apiClient;
    private ApiVersion apiVersion;
    private CommitsApi commitsApi;
    private GroupApi groupApi;
    private MergeRequestApi mergeRequestApi;
    private NamespaceApi namespaceApi;
    private ProjectApi projectApi;
    private RepositoryApi repositoryApi;
    private RepositoryFileApi repositoryFileApi;
    private ServicesApi servicesApi;
    private SessionApi sessoinApi;
    private UserApi userApi;
    private Session session;

    public static GitLabApi login(ApiVersion apiVersion, String url, String username, String password) throws GitLabApiException {
        SessionApi sessionApi = new SessionApi(new GitLabApi(apiVersion, url, (String)null));
        Session session = sessionApi.login(username, null, password);
        return new GitLabApi(url, session);
    }

    public static GitLabApi login(String url, String username, String password) throws GitLabApiException {
        return GitLabApi.login(ApiVersion.V4, url, username, password);
    }

    @Deprecated
    public static GitLabApi create(String url, String username, String password) throws GitLabApiException {
        return GitLabApi.login(url, username, password);
    }

    public Session getSession() {
        return this.session;
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken) {
        this(apiVersion, hostUrl, privateToken, null);
    }

    public GitLabApi(String hostUrl, String privateToken) {
        this(ApiVersion.V4, hostUrl, privateToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Session session) {
        this(apiVersion, hostUrl, session.getPrivateToken(), null);
        this.session = session;
    }

    public GitLabApi(String hostUrl, Session session) {
        this(ApiVersion.V4, hostUrl, session);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken) {
        this(apiVersion, hostUrl, privateToken, secretToken, null);
    }

    public GitLabApi(String hostUrl, String privateToken, String secretToken) {
        this(ApiVersion.V4, hostUrl, privateToken, secretToken);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this.apiVersion = apiVersion;
        this.apiClient = new GitLabApiClient(apiVersion, hostUrl, privateToken, secretToken, clientConfigProperties);
        this.commitsApi = new CommitsApi(this);
        this.groupApi = new GroupApi(this);
        this.mergeRequestApi = new MergeRequestApi(this);
        this.setNamespaceApi(new NamespaceApi(this));
        this.projectApi = new ProjectApi(this);
        this.repositoryApi = new RepositoryApi(this);
        this.servicesApi = new ServicesApi(this);
        this.sessoinApi = new SessionApi(this);
        this.userApi = new UserApi(this);
        this.repositoryFileApi = new RepositoryFileApi(this);
    }

    public GitLabApi(String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(ApiVersion.V4, hostUrl, privateToken, secretToken, clientConfigProperties);
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    GitLabApiClient getApiClient() {
        return this.apiClient;
    }

    public CommitsApi getCommitsApi() {
        return this.commitsApi;
    }

    public MergeRequestApi getMergeRequestApi() {
        return this.mergeRequestApi;
    }

    public NamespaceApi getNamespaceApi() {
        return this.namespaceApi;
    }

    public void setNamespaceApi(NamespaceApi namespaceApi) {
        this.namespaceApi = namespaceApi;
    }

    public GroupApi getGroupApi() {
        return this.groupApi;
    }

    public ProjectApi getProjectApi() {
        return this.projectApi;
    }

    public RepositoryApi getRepositoryApi() {
        return this.repositoryApi;
    }

    public RepositoryFileApi getRepositoryFileApi() {
        return this.repositoryFileApi;
    }

    public ServicesApi getServicesApi() {
        return this.servicesApi;
    }

    public SessionApi getSessionApi() {
        return this.sessoinApi;
    }

    public UserApi getUserApi() {
        return this.userApi;
    }

    public static enum ApiVersion {
        V3,
        V4;


        public String getApiNamespace() {
            return "/api/" + this.name().toLowerCase();
        }
    }
}

