/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import java.util.Date;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Visibility;

public class ProjectFilter {
    private Boolean archived;
    private Visibility visibility;
    private Constants.ProjectOrderBy orderBy;
    private Constants.SortOrder sort;
    private String search;
    private Boolean searchNamespaces;
    private Boolean simple;
    private Boolean owned;
    private Boolean membership;
    private Boolean starred;
    private Boolean statistics;
    private Boolean withCustomAttributes;
    private Boolean withIssuesEnabled;
    private Boolean withMergeRequestsEnabled;
    private String withProgrammingLanguage;
    private Boolean wikiChecksumFailed;
    private Boolean repositoryChecksumFailed;
    private AccessLevel minAccessLevel;
    private Integer idAfter;
    private Integer idBefore;
    private Date lastActivityAfter;
    private Date lastActivityBefore;
    private String repositoryStorage;

    public ProjectFilter withArchived(Boolean archived) {
        this.archived = archived;
        return this;
    }

    public ProjectFilter withVisibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public ProjectFilter withOrderBy(Constants.ProjectOrderBy orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public ProjectFilter withSortOder(Constants.SortOrder sort) {
        this.sort = sort;
        return this;
    }

    public ProjectFilter withSearch(String search) {
        this.search = search;
        return this;
    }

    public ProjectFilter withSearchNamespaces(Boolean searchNamespaces) {
        this.searchNamespaces = searchNamespaces;
        return this;
    }

    public ProjectFilter withSimple(Boolean simple) {
        this.simple = simple;
        return this;
    }

    public ProjectFilter withOwned(Boolean owned) {
        this.owned = owned;
        return this;
    }

    public ProjectFilter withMembership(Boolean membership) {
        this.membership = membership;
        return this;
    }

    public ProjectFilter withStarred(Boolean starred) {
        this.starred = starred;
        return this;
    }

    public ProjectFilter withStatistics(Boolean statistics) {
        this.statistics = statistics;
        return this;
    }

    public ProjectFilter withCustomAttributes(Boolean withCustomAttributes) {
        this.withCustomAttributes = withCustomAttributes;
        return this;
    }

    public ProjectFilter withIssuesEnabled(Boolean withIssuesEnabled) {
        this.withIssuesEnabled = withIssuesEnabled;
        return this;
    }

    public ProjectFilter withMergeRequestsEnabled(Boolean withMergeRequestsEnabled) {
        this.withMergeRequestsEnabled = withMergeRequestsEnabled;
        return this;
    }

    public ProjectFilter withProgrammingLanguage(String withProgrammingLanguage) {
        this.withProgrammingLanguage = withProgrammingLanguage;
        return this;
    }

    public ProjectFilter withWikiChecksumFailed(Boolean wikiChecksumFailed) {
        this.wikiChecksumFailed = wikiChecksumFailed;
        return this;
    }

    public ProjectFilter withRepositoryChecksumFailed(Boolean repositoryChecksumFailed) {
        this.repositoryChecksumFailed = repositoryChecksumFailed;
        return this;
    }

    public ProjectFilter minAccessLevel(AccessLevel minAccessLevel) {
        this.minAccessLevel = minAccessLevel;
        return this;
    }

    public ProjectFilter withMinAccessLevel(AccessLevel minAccessLevel) {
        this.minAccessLevel = minAccessLevel;
        return this;
    }

    public ProjectFilter withIdAfter(Integer idAfter) {
        this.idAfter = idAfter;
        return this;
    }

    public ProjectFilter withIdBefore(Integer idBefore) {
        this.idBefore = idBefore;
        return this;
    }

    public ProjectFilter withLastActivityAfter(Date lastActivityAfter) {
        this.lastActivityAfter = lastActivityAfter;
        return this;
    }

    public ProjectFilter withLastActivityBefore(Date lastActivityBefore) {
        this.lastActivityBefore = lastActivityBefore;
        return this;
    }

    public ProjectFilter withRepositoryStorage(String repositoryStorage) {
        this.repositoryStorage = repositoryStorage;
        return this;
    }

    public GitLabApiForm getQueryParams(int page, int perPage) {
        return this.getQueryParams().withParam("page", page).withParam("per_page", perPage);
    }

    public GitLabApiForm getQueryParams() {
        return new GitLabApiForm().withParam("archived", this.archived).withParam("visibility", (Object)this.visibility).withParam("order_by", (Object)this.orderBy).withParam("sort", (Object)this.sort).withParam("search", this.search).withParam("search_namespaces", this.searchNamespaces).withParam("simple", this.simple).withParam("owned", this.owned).withParam("membership", this.membership).withParam("starred", this.starred).withParam("statistics", this.statistics).withParam("with_custom_attributes", this.withCustomAttributes).withParam("with_issues_enabled", this.withIssuesEnabled).withParam("with_merge_requests_enabled", this.withMergeRequestsEnabled).withParam("with_programming_language", this.withProgrammingLanguage).withParam("wiki_checksum_failed", this.wikiChecksumFailed).withParam("repository_checksum_failed", this.repositoryChecksumFailed).withParam("min_access_level", this.minAccessLevel != null ? this.minAccessLevel.toValue() : null).withParam("id_after", this.idAfter).withParam("id_before", this.idBefore).withParam("last_activity_after", this.lastActivityAfter).withParam("last_activity_before", this.lastActivityBefore).withParam("repository_storage", this.repositoryStorage);
    }
}

