/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.DeployToken;

public class DeployTokensApi
extends AbstractApi {
    public DeployTokensApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<DeployToken> getDeployTokens() throws GitLabApiException {
        return this.getDeployTokens(this.getDefaultPerPage()).all();
    }

    public Pager<DeployToken> getDeployTokens(int itemsPerPage) throws GitLabApiException {
        return new Pager<DeployToken>(this, DeployToken.class, itemsPerPage, null, "deploy_tokens");
    }

    public Stream<DeployToken> getDeployTokensStream() throws GitLabApiException {
        return this.getDeployTokens(this.getDefaultPerPage()).stream();
    }

    public List<DeployToken> getProjectDeployTokens(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployTokens(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<DeployToken> getProjectDeployTokens(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<DeployToken>(this, DeployToken.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_tokens");
    }

    public Stream<DeployToken> getProjectDeployTokensStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployTokens(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public DeployToken addProjectDeployToken(Object projectIdOrPath, String name, Date expiresAt, String username, List<Constants.DeployTokenScope> scopes) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("expires_at", expiresAt, true).withParam("username", username, true).withParam("scopes", scopes, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_tokens"});
        return (DeployToken)response.readEntity(DeployToken.class);
    }

    public void deleteProjectDeployToken(Object projectIdOrPath, Integer tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_tokens", tokenId);
    }

    public List<DeployToken> getGroupDeployTokens(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupDeployTokens(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<DeployToken> getGroupDeployTokens(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<DeployToken>(this, DeployToken.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "deploy_tokens");
    }

    public Stream<DeployToken> getGroupDeployTokensStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupDeployTokens(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public DeployToken addGroupDeployToken(Object groupIdOrPath, String name, Date expiresAt, String username, List<Constants.DeployTokenScope> scopes) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("expires_at", expiresAt, true).withParam("username", username, true).withParam("scopes", scopes, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "deploy_tokens"});
        return (DeployToken)response.readEntity(DeployToken.class);
    }

    public void deleteGroupDeployToken(Object groupIdOrPath, Integer tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "deploy_tokens", tokenId);
    }
}

