/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.AuditEvent;
import org.gitlab4j.api.utils.ISO8601;

public class AuditEventApi
extends AbstractApi {
    public AuditEventApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<AuditEvent> getAuditEvents(Date created_after, Date created_before, String entityType, Integer entityId) throws GitLabApiException {
        return this.getAuditEvents(created_after, created_before, entityType, entityId, this.getDefaultPerPage()).all();
    }

    public Pager<AuditEvent> getAuditEvents(Date created_after, Date created_before, String entityType, Integer entityId, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("created_before", ISO8601.toString(created_before, false)).withParam("created_after", ISO8601.toString(created_after, false)).withParam("entity_type", entityType).withParam("entity_id", entityId);
        return new Pager<AuditEvent>(this, AuditEvent.class, itemsPerPage, (MultivaluedMap<String, String>)form.asMap(), "audit_events");
    }

    public Stream<AuditEvent> getAuditEventsStream(Date created_after, Date created_before, String entityType, Integer entityId) throws GitLabApiException {
        return this.getAuditEvents(created_after, created_before, entityType, entityId, this.getDefaultPerPage()).stream();
    }

    public AuditEvent getAuditEvent(Integer auditEventId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "audit_events", auditEventId);
        return (AuditEvent)response.readEntity(AuditEvent.class);
    }
}

