/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.skeleton.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.skeleton.SkeletonFisbone;
import org.gagravarr.skeleton.SkeletonFishead;
import org.gagravarr.skeleton.SkeletonPacketFactory;
import org.gagravarr.skeleton.SkeletonStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkeletonInfoTool {
    private static boolean debugging = false;
    private File file;
    private OggFile ogg;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            SkeletonInfoTool.printHelp();
        }
        String filename = args[0];
        if (args.length > 1 && args[0].equals("-d")) {
            filename = args[1];
            debugging = true;
        }
        SkeletonInfoTool info = new SkeletonInfoTool(new File(filename));
        info.printStreamInfo();
    }

    public static void printHelp() {
        System.err.println("Use:");
        System.err.println("  SkeletonInfoTool file.ogg");
        System.exit(1);
    }

    public SkeletonInfoTool(File f) throws IOException {
        this(new OggFile((InputStream)new FileInputStream(f)));
        this.file = f;
    }

    protected SkeletonInfoTool(OggFile ogg) {
        this.ogg = ogg;
    }

    public static List<SkeletonStream> getSkeletonStreams(OggPacketReader r) throws IOException {
        OggPacket p;
        HashMap<Integer, SkeletonStream> skelIds = new HashMap<Integer, SkeletonStream>();
        ArrayList<SkeletonStream> skels = new ArrayList<SkeletonStream>();
        int streams = 0;
        while ((p = r.getNextPacket()) != null) {
            Integer sidI = p.getSid();
            if (p.isBeginningOfStream()) {
                ++streams;
                if (SkeletonPacketFactory.isSkeletonStream((OggPacket)p)) {
                    SkeletonStream skel = new SkeletonStream(p);
                    skelIds.put(sidI, skel);
                    skels.add(skel);
                    if (debugging) {
                        System.out.println("Found skeleton in stream at " + streams + " with SID " + skel.getSid());
                    }
                } else if (debugging) {
                    System.out.println("Found non-skeleton stream at " + streams + " with SID " + p.getSid());
                }
            }
            if (!skelIds.containsKey(p.getSid())) continue;
            ((SkeletonStream)skelIds.get(sidI)).processPacket(p);
        }
        return skels;
    }

    public void printStreamInfo() throws IOException {
        OggPacketReader r = this.ogg.getPacketReader();
        System.out.println("Processing file \"" + this.file + "\"");
        List<SkeletonStream> skeletons = SkeletonInfoTool.getSkeletonStreams(r);
        for (SkeletonStream skel : skeletons) {
            System.out.println();
            System.out.println("Skeleton with serial " + SkeletonInfoTool.formatSid(skel.getSid()));
            SkeletonFishead head = skel.getFishead();
            System.out.println(" - Skeleton version: " + head.getVersion());
            System.out.println(" - Created at: " + head.getUtc());
            int bones = 0;
            for (SkeletonFisbone bone : skel.getFisbones()) {
                System.out.println(" * Bone " + ++bones);
                System.out.println("  - For stream " + SkeletonInfoTool.formatSid(bone.getSerialNumber()));
                System.out.println("  - Message Headers:");
                for (String key : bone.getMessageHeaders().keySet()) {
                    System.out.println("   * " + key + " = " + (String)bone.getMessageHeaders().get(key));
                }
            }
            if (skel.getKeyFrames().isEmpty()) {
                System.out.println(" * No key frames found");
                continue;
            }
            System.out.println(" * " + skel.getKeyFrames().size() + " keyframes");
        }
        if (skeletons.isEmpty()) {
            System.out.println();
            System.out.println("There are no Skeleton streams in the file");
        }
    }

    protected static String formatSid(int sid) {
        StringBuffer s = new StringBuffer();
        s.append(sid);
        s.append(" (0x");
        s.append(Integer.toHexString(sid));
        s.append(")");
        return s.toString();
    }
}

