/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.vorbis.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.vorbis.VorbisAudioData;
import org.gagravarr.vorbis.VorbisFile;

public class VorbisInfoTool {
    public static void main(String[] args) throws Exception {
        VorbisAudioData vad;
        if (args.length == 0) {
            VorbisInfoTool.printHelp();
        }
        boolean debugging = false;
        String filename = args[0];
        if (args.length > 1 && args[0].equals("-d")) {
            filename = args[1];
            debugging = true;
        }
        InfoPacketReader r = new InfoPacketReader(new FileInputStream(filename));
        VorbisFile vf = new VorbisFile((OggPacketReader)r);
        System.out.println("Processing file \"" + filename + "\"");
        System.out.println("");
        System.out.println("Vorbis Headers:");
        System.out.println("  Version: " + vf.getInfo().getVersion());
        System.out.println("  Vendor: " + vf.getComment().getVendor());
        System.out.println("  Channels: " + vf.getInfo().getChannels());
        System.out.println("  Rate: " + vf.getInfo().getRate());
        System.out.println("");
        System.out.println("  Nominal Bitrate: " + vf.getInfo().getBitrateNominal());
        System.out.println("  Lower Bitrate: " + vf.getInfo().getBitrateLower());
        System.out.println("  Upper Bitrate: " + vf.getInfo().getBitrateUpper());
        System.out.println("");
        System.out.println("User Comments:");
        VorbisInfoTool.listTags(vf);
        System.out.println("");
        System.out.println("Vorbis Setup:");
        System.out.println("  Codebooks: " + vf.getSetup().getNumberOfCodebooks());
        System.out.println("");
        int dataPackets = 0;
        long dataSize = 0L;
        long lastGranule = 0L;
        while ((vad = vf.getNextAudioPacket()) != null) {
            ++dataPackets;
            dataSize += (long)vad.getData().length;
            lastGranule = vad.getGranulePosition();
            if (!debugging) continue;
            System.out.println(r.lastSeqNum + " - " + vad.getGranulePosition() + " - " + vad.getData().length + " bytes");
        }
        float seconds = lastGranule / vf.getInfo().getRate();
        int minutes = (int)(seconds / 60.0f);
        System.out.println("");
        System.out.println("Vorbis Audio:");
        System.out.println("  Total Data Packets: " + dataPackets);
        System.out.println("  Total Data Length: " + dataSize);
        System.out.println("  Audio Length: " + minutes + "m:" + (int)(seconds -= (float)(minutes * 60)) + "s");
    }

    public static void printHelp() {
        System.err.println("Use:");
        System.err.println("  VorbisInfoTool file.ogg");
        System.exit(1);
    }

    public static void listTags(VorbisFile vf) throws Exception {
        Map comments = vf.getComment().getAllComments();
        for (String tag : comments.keySet()) {
            for (String value : (List)comments.get(tag)) {
                System.out.println("  " + tag + "=" + value);
            }
        }
    }

    protected static class InfoPacketReader
    extends OggPacketReader {
        private boolean inProgress = false;
        private int lastSeqNum = 0;

        public InfoPacketReader(InputStream inp) {
            super(inp);
        }

        public OggPacket getNextPacket() throws IOException {
            if (this.inProgress) {
                this.inProgress = false;
                return super.getNextPacket();
            }
            this.inProgress = true;
            OggPacket p = super.getNextPacket();
            this.inProgress = false;
            if (p != null) {
                this.lastSeqNum = p.getSequenceNumber();
                if (p.isBeginningOfStream()) {
                    System.out.println("New logical stream " + Integer.toHexString(p.getSid()) + " (" + p.getSid() + ") found");
                }
                if (p.isEndOfStream()) {
                    System.out.println("Logical stream " + Integer.toHexString(p.getSid()) + " (" + p.getSid() + ") completed");
                }
            }
            return p;
        }

        public OggPacket getNextPacketWithSid(int sid) throws IOException {
            OggPacket p;
            while ((p = this.getNextPacket()) != null) {
                if (p.getSid() != sid) {
                    System.out.println("Ignoring packet from stream " + Integer.toHexString(p.getSid()));
                    continue;
                }
                return p;
            }
            return null;
        }
    }
}

