/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.tooling.testing.pax.exam.karaf;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.features.FeaturesService;
import org.fusesource.tooling.testing.pax.exam.karaf.ServiceLocator;
import org.junit.Assert;
import org.openengsb.labs.paxexam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.junit.ProbeBuilder;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FuseTestSupport {
    public static final Long DEFAULT_TIMEOUT = 10000L;
    public static final Long SYSTEM_TIMEOUT = 30000L;
    public static final Long DEFAULT_WAIT = 10000L;
    public static final Long PROVISION_TIMEOUT = 300000L;
    public static final Long COMMAND_TIMEOUT = 30000L;
    protected ExecutorService executor = Executors.newCachedThreadPool();
    @Inject
    protected BundleContext bundleContext;

    protected Bundle installBundle(String groupId, String artifactId) throws Exception {
        MavenArtifactProvisionOption mvnUrl = FuseTestSupport.mavenBundle(groupId, artifactId);
        return this.bundleContext.installBundle(mvnUrl.getURL());
    }

    protected Bundle getInstalledBundle(String symbolicName) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName)) continue;
            return b;
        }
        for (Bundle b : this.bundleContext.getBundles()) {
            System.err.println("Bundle: " + b.getSymbolicName());
        }
        throw new RuntimeException("Bundle " + symbolicName + " does not exist");
    }

    public static Option copySystemProperty(String propertyName) {
        return KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)propertyName, (String)(System.getProperty(propertyName) != null ? System.getProperty(propertyName) : ""));
    }

    protected static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId) {
        return CoreOptions.mavenBundle((String)groupId, (String)artifactId).versionAsInProject();
    }

    protected static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId, String version) {
        return CoreOptions.mavenBundle((String)groupId, (String)artifactId).version(version);
    }

    protected String executeCommand(String command) {
        return this.executeCommand(command, COMMAND_TIMEOUT, false);
    }

    protected String executeCommand(final String command, Long timeout, final Boolean silent) {
        String response;
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final PrintStream printStream = new PrintStream(byteArrayOutputStream);
        CommandProcessor commandProcessor = ServiceLocator.getOsgiService(CommandProcessor.class);
        final CommandSession commandSession = commandProcessor.createSession(System.in, printStream, printStream);
        commandSession.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
        commandSession.put("USER", (Object)"karaf");
        FutureTask<String> commandFuture = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() {
                try {
                    if (!silent.booleanValue()) {
                        System.out.println(command);
                        System.out.flush();
                    }
                    commandSession.execute((CharSequence)command);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                printStream.flush();
                return byteArrayOutputStream.toString();
            }
        });
        try {
            this.executor.submit(commandFuture);
            response = commandFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            response = "SHELL COMMAND TIMED OUT: ";
        }
        return response;
    }

    protected String executeCommands(final String ... commands) {
        String response;
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        CommandProcessor commandProcessor = ServiceLocator.getOsgiService(CommandProcessor.class);
        final CommandSession commandSession = commandProcessor.createSession(System.in, printStream, printStream);
        commandSession.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
        commandSession.put("USER", (Object)"karaf");
        FutureTask<String> commandFuture = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() {
                try {
                    for (String command : commands) {
                        System.out.println(command);
                        System.out.flush();
                        commandSession.execute((CharSequence)command);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                return byteArrayOutputStream.toString();
            }
        });
        try {
            this.executor.submit(commandFuture);
            response = commandFuture.get(COMMAND_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            response = "SHELL COMMAND TIMED OUT: ";
        }
        return response;
    }

    public void installAndCheckFeature(String feature) throws Exception {
        System.err.println(this.executeCommand("features:install " + feature));
        FeaturesService featuresService = ServiceLocator.getOsgiService(FeaturesService.class);
        System.err.println(this.executeCommand("osgi:list -t 0"));
        Assert.assertTrue((String)("Expected " + feature + " feature to be installed."), (boolean)featuresService.isInstalled(featuresService.getFeature(feature)));
    }

    public void unInstallAndCheckFeature(String feature) throws Exception {
        System.err.println(this.executeCommand("features:uninstall " + feature));
        FeaturesService featuresService = ServiceLocator.getOsgiService(FeaturesService.class);
        System.err.println(this.executeCommand("osgi:list -t 0"));
        Assert.assertFalse((String)("Expected " + feature + " feature to be installed."), (boolean)featuresService.isInstalled(featuresService.getFeature(feature)));
    }

    @ProbeBuilder
    public TestProbeBuilder probeConfiguration(TestProbeBuilder probe) {
        probe.setHeader("DynamicImport-Package", "*,org.apache.felix.service.*;status=provisional");
        return probe;
    }
}

