/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.tooling.testing.pax.exam.karaf;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.features.FeaturesService;
import org.junit.Assert;
import org.openengsb.labs.paxexam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.junit.ProbeBuilder;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class FuseTestSupport {
    public static final Long DEFAULT_TIMEOUT = 10000L;
    public static final Long SYSTEM_TIMEOUT = 30000L;
    public static final Long DEFAULT_WAIT = 10000L;
    public static final Long PROVISION_TIMEOUT = 120000L;
    public static final Long COMMAND_TIMEOUT = 30000L;
    protected ExecutorService executor = Executors.newCachedThreadPool();
    @Inject
    protected BundleContext bundleContext;

    protected Bundle installBundle(String groupId, String artifactId) throws Exception {
        MavenArtifactProvisionOption mvnUrl = FuseTestSupport.mavenBundle(groupId, artifactId);
        return this.bundleContext.installBundle(mvnUrl.getURL());
    }

    protected Bundle getInstalledBundle(String symbolicName) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName)) continue;
            return b;
        }
        for (Bundle b : this.bundleContext.getBundles()) {
            System.err.println("Bundle: " + b.getSymbolicName());
        }
        throw new RuntimeException("Bundle " + symbolicName + " does not exist");
    }

    private static String explode(Dictionary dictionary) {
        Enumeration keys = dictionary.keys();
        StringBuffer result = new StringBuffer();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            result.append(String.format("%s=%s", key, dictionary.get(key)));
            if (!keys.hasMoreElements()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    protected <T> T getOsgiService(Class<T> type, long timeout) {
        return this.getOsgiService(type, null, timeout);
    }

    protected <T> T getOsgiService(Class<T> type) {
        return this.getOsgiService(type, null, DEFAULT_TIMEOUT);
    }

    protected <T> T getOsgiService(Class<T> type, String filter, long timeout) {
        ServiceTracker tracker = null;
        try {
            String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type.getName() + ")" + filter + ")" : "(&(objectClass=" + type.getName() + ")(" + filter + "))") : "(objectClass=" + type.getName() + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            tracker = new ServiceTracker(this.bundleContext, osgiFilter, null);
            tracker.open(true);
            T svc = type.cast(tracker.waitForService(timeout));
            if (svc == null) {
                Dictionary dic = this.bundleContext.getBundle().getHeaders();
                System.err.println("Test bundle headers: " + FuseTestSupport.explode(dic));
                for (ServiceReference ref : FuseTestSupport.asCollection(this.bundleContext.getAllServiceReferences(null, null))) {
                    System.err.println("ServiceReference: " + ref);
                }
                for (ServiceReference ref : FuseTestSupport.asCollection(this.bundleContext.getAllServiceReferences(null, flt))) {
                    System.err.println("Filtered ServiceReference: " + ref);
                }
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
            return type.cast(svc);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Option copySystemProperty(String propertyName) {
        return KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)propertyName, (String)(System.getProperty(propertyName) != null ? System.getProperty(propertyName) : ""));
    }

    private static Collection<ServiceReference> asCollection(ServiceReference[] references) {
        return references != null ? Arrays.asList(references) : Collections.emptyList();
    }

    protected static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId) {
        return CoreOptions.mavenBundle((String)groupId, (String)artifactId).versionAsInProject();
    }

    protected static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId, String version) {
        return CoreOptions.mavenBundle((String)groupId, (String)artifactId).version(version);
    }

    protected String executeCommand(String command) {
        return this.executeCommand(command, COMMAND_TIMEOUT, false);
    }

    protected String executeCommand(final String command, Long timeout, final Boolean silent) {
        String response;
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final PrintStream printStream = new PrintStream(byteArrayOutputStream);
        CommandProcessor commandProcessor = this.getOsgiService(CommandProcessor.class);
        final CommandSession commandSession = commandProcessor.createSession(System.in, printStream, printStream);
        commandSession.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
        commandSession.put("USER", (Object)"karaf");
        FutureTask<String> commandFuture = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() {
                try {
                    if (!silent.booleanValue()) {
                        System.out.println(command);
                        System.out.flush();
                    }
                    commandSession.execute((CharSequence)command);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                printStream.flush();
                return byteArrayOutputStream.toString();
            }
        });
        try {
            this.executor.submit(commandFuture);
            response = commandFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            response = "SHELL COMMAND TIMED OUT: ";
        }
        return response;
    }

    protected String executeCommands(final String ... commands) {
        String response;
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        CommandProcessor commandProcessor = this.getOsgiService(CommandProcessor.class);
        final CommandSession commandSession = commandProcessor.createSession(System.in, printStream, printStream);
        commandSession.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
        commandSession.put("USER", (Object)"karaf");
        FutureTask<String> commandFuture = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() {
                try {
                    for (String command : commands) {
                        System.out.println(command);
                        commandSession.execute((CharSequence)command);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                return byteArrayOutputStream.toString();
            }
        });
        try {
            this.executor.submit(commandFuture);
            response = commandFuture.get(COMMAND_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            response = "SHELL COMMAND TIMED OUT: ";
        }
        return response;
    }

    public void installAndCheckFeature(String feature) throws Exception {
        System.err.println(this.executeCommand("features:install " + feature));
        FeaturesService featuresService = this.getOsgiService(FeaturesService.class);
        System.err.println(this.executeCommand("osgi:list -t 0"));
        Assert.assertTrue((String)("Expected " + feature + " feature to be installed."), (boolean)featuresService.isInstalled(featuresService.getFeature(feature)));
    }

    public void unInstallAndCheckFeature(String feature) throws Exception {
        System.err.println(this.executeCommand("features:uninstall " + feature));
        FeaturesService featuresService = this.getOsgiService(FeaturesService.class);
        System.err.println(this.executeCommand("osgi:list -t 0"));
        Assert.assertFalse((String)("Expected " + feature + " feature to be installed."), (boolean)featuresService.isInstalled(featuresService.getFeature(feature)));
    }

    @ProbeBuilder
    public TestProbeBuilder probeConfiguration(TestProbeBuilder probe) {
        probe.setHeader("DynamicImport-Package", "*,org.apache.felix.service.*;status=provisional");
        return probe;
    }
}

