/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.client;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.FutureConnection;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;

public class BlockingConnection {
    private final FutureConnection next;

    public BlockingConnection(FutureConnection next) {
        this.next = next;
    }

    public boolean isConnected() {
        return this.next.isConnected();
    }

    public void connect() throws Exception {
        this.next.connect().await();
    }

    public void disconnect() throws Exception {
        this.next.disconnect().await();
    }

    public void kill() throws Exception {
        this.next.kill().await();
    }

    public byte[] subscribe(Topic[] topics) throws Exception {
        return this.next.subscribe(topics).await();
    }

    public void unsubscribe(String[] topics) throws Exception {
        this.next.unsubscribe(topics).await();
    }

    public void unsubscribe(UTF8Buffer[] topics) throws Exception {
        this.next.unsubscribe(topics).await();
    }

    public void publish(UTF8Buffer topic, Buffer payload, QoS qos, boolean retain) throws Exception {
        this.next.publish(topic, payload, qos, retain).await();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void publish(String topic, byte[] payload, QoS qos, boolean retain) throws Exception {
        this.publish(Buffer.utf8(topic), new Buffer(payload), qos, retain);
    }

    public Message receive() throws Exception {
        return this.next.receive().await();
    }

    public Message receive(long amount, TimeUnit unit) throws Exception {
        try {
            return this.next.receive().await(amount, unit);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public void resume() {
        this.next.resume();
    }

    public void suspend() {
        this.next.suspend();
    }
}

