/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.lang;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import net.sf.retrotranslator.runtime.impl.ClassDescriptor;
import net.sf.retrotranslator.runtime.impl.MethodDescriptor;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.runtime.java.lang.Iterable_;

public class _Class {
    private static final String[] RUNTIME_PREFIXES = _Class.getPrefixes();
    static /* synthetic */ Class class$net$sf$retrotranslator$runtime$java$lang$Iterable_;
    static /* synthetic */ Class class$net$sf$retrotranslator$runtime$java$lang$_Class;
    static /* synthetic */ Class class$java$lang$StringBuffer;

    public static Class forName(String name) throws ClassNotFoundException {
        return _Class.forName(name, true, _Class.getCallerClassLoader());
    }

    public static Class forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        try {
            return Class.forName(name, initialize, loader);
        }
        catch (ClassNotFoundException e) {
            String[] arr$ = RUNTIME_PREFIXES;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String prefix = arr$[i$];
                try {
                    return Class.forName(prefix + name + "_", initialize, loader);
                }
                catch (ClassNotFoundException ex) {
                    continue;
                }
            }
            try {
                return Class.forName(RuntimeTools.CONCURRENT_PREFIX + name, initialize, loader);
            }
            catch (ClassNotFoundException ex) {
                if (name.equals("java.lang.StringBuilder")) {
                    Class<?> clazz = class$java$lang$StringBuffer;
                    if (clazz == null) {
                        clazz = class$java$lang$StringBuffer = new StringBuffer[0].getClass().getComponentType();
                    }
                    return clazz;
                }
                throw e;
            }
        }
    }

    public static Class getEnclosingClass(Class aClass) {
        MethodDescriptor descriptor = ClassDescriptor.getInstance(aClass).getEnclosingMethodDescriptor();
        return descriptor == null ? aClass.getDeclaringClass() : descriptor.getClassDescriptor().getTarget();
    }

    public static Method getMethod(Class aClass, String name, Class[] parameterTypes) throws NoSuchMethodException, SecurityException {
        Method method = _Class.findMethod(aClass.getMethods(), name, parameterTypes);
        if (method != null) {
            return method;
        }
        method = _Class.findBackportedMethod(aClass, name, parameterTypes);
        if (method != null) {
            return method;
        }
        return aClass.getMethod(name, parameterTypes);
    }

    public static String getSimpleName(Class aClass) {
        if (aClass.isArray()) {
            return _Class.getSimpleName(aClass.getComponentType()) + "[]";
        }
        String thisName = aClass.getName();
        Class enclosingClass = _Class.getEnclosingClass(aClass);
        if (enclosingClass == null) {
            return thisName.substring(thisName.lastIndexOf(46) + 1);
        }
        String enclosingName = enclosingClass.getName();
        if (!thisName.startsWith(enclosingName)) {
            throw new InternalError();
        }
        String name = thisName.substring(enclosingName.length());
        if (!name.startsWith("$")) {
            throw new InternalError();
        }
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return name.substring(i);
        }
        return "";
    }

    private static String[] getPrefixes() {
        String p;
        Class<?> clazz = class$net$sf$retrotranslator$runtime$java$lang$Iterable_;
        if (clazz == null) {
            clazz = class$net$sf$retrotranslator$runtime$java$lang$Iterable_ = new Iterable_[0].getClass().getComponentType();
        }
        if ((p = RuntimeTools.getPrefix("java.lang.Iterable_", clazz)) == null) {
            return new String[0];
        }
        if (p.endsWith(".v15.")) {
            return new String[]{p, p.substring(0, p.length() - 5) + ".v14."};
        }
        return new String[]{p};
    }

    private static ClassLoader getCallerClassLoader() {
        Class<?> clazz = class$net$sf$retrotranslator$runtime$java$lang$_Class;
        if (clazz == null) {
            clazz = class$net$sf$retrotranslator$runtime$java$lang$_Class = new _Class[0].getClass().getComponentType();
        }
        final Class<?> thisClass = clazz;
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                try {
                    Class[] context = new SecurityManager(){

                        protected Class[] getClassContext() {
                            return super.getClassContext();
                        }
                    }.getClassContext();
                    boolean found = false;
                    for (Class aClass : context) {
                        if (aClass == thisClass) {
                            found = true;
                            continue;
                        }
                        if (!found) continue;
                        return aClass.getClassLoader();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return thisClass.getClassLoader();
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    private static Method findMethod(Method[] methods, String name, Class[] parameterTypes) {
        Method result = null;
        Method[] arr$ = methods;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            if (!method.getName().equals(name) || !Arrays.equals(method.getParameterTypes(), parameterTypes) || result != null && !result.getReturnType().isAssignableFrom(method.getReturnType())) continue;
            result = method;
        }
        return result;
    }

    private static Method findBackportedMethod(Class aClass, String name, Class[] parameterTypes) {
        String[] arr$ = RUNTIME_PREFIXES;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int index;
            String prefix = arr$[i$];
            String s = prefix + aClass.getName();
            String className = s.substring(0, (index = s.lastIndexOf(46)) + 1) + "_" + s.substring(index + 1);
            Method method = _Class.findStaticMethod(className, name, parameterTypes);
            if (method == null) continue;
            return method;
        }
        return _Class.findStaticMethod(RuntimeTools.CONCURRENT_PREFIX + aClass.getName(), name, parameterTypes);
    }

    private static Method findStaticMethod(String className, String methodName, Class[] parameterTypes) {
        try {
            Method method = Class.forName(className).getMethod(methodName, parameterTypes);
            if (Modifier.isStatic(method.getModifiers())) {
                return method;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

