/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.fusesource.hawtdispatch.internal.NioAttachment;
import org.fusesource.hawtdispatch.internal.NioDispatchSource;

public class NioManager {
    final SelectStrategy selectStrategy = Boolean.getBoolean("hawtdispatch.workaround-select-spin") ? new WorkAroundSelectSpin() : new SelectStrategy();
    private Selector selector;
    protected final AtomicInteger wakeupCounter = new AtomicInteger();
    protected volatile int selectCounter;
    protected volatile boolean selecting;
    private final boolean TRACE = false;
    private final LinkedList<String> traces = new LinkedList();

    public NioManager() throws IOException {
        this.selector = Selector.open();
    }

    Selector getSelector() {
        return this.selector;
    }

    public boolean wakeupIfSelecting() {
        if (this.wakeupCounter.getAndIncrement() == this.selectCounter && this.selecting) {
            this.selector.wakeup();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int select(long timeout) throws IOException {
        block8: {
            try {
                if (timeout == 0L) {
                    this.selector.selectNow();
                    break block8;
                }
                this.selecting = true;
                try {
                    if (this.selectCounter == this.wakeupCounter.get()) {
                        this.selectStrategy.select(timeout);
                    } else {
                        this.selector.selectNow();
                    }
                }
                finally {
                    this.selecting = false;
                    this.selectCounter = this.wakeupCounter.get();
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
        return this.processSelected();
    }

    private int processSelected() {
        if (this.selector.keys().isEmpty()) {
            return 0;
        }
        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
        int size = selectedKeys.size();
        if (size != 0) {
            this.trace("selected: %d", new Object[]{_Integer.valueOf(size)});
            ArrayList<SelectionKey> copy = new ArrayList<SelectionKey>(this.selector.selectedKeys());
            this.selector.selectedKeys().clear();
            Iterator<SelectionKey> i$ = copy.iterator();
            while (i$.hasNext()) {
                SelectionKey key = i$.next();
                if (key.isValid()) {
                    try {
                        key.interestOps(key.interestOps() & ~key.readyOps());
                        ((NioAttachment)key.attachment()).selected(key);
                    }
                    catch (CancelledKeyException e) {
                        ((NioAttachment)key.attachment()).cancel(key);
                    }
                    continue;
                }
                ((NioAttachment)key.attachment()).cancel(key);
            }
        }
        return size;
    }

    protected void trace(String str, Object[] args) {
    }

    class WorkAroundSelectSpin
    extends SelectStrategy {
        int spins;

        WorkAroundSelectSpin() {
        }

        public boolean wakeupPending() {
            return NioManager.this.selectCounter != NioManager.this.wakeupCounter.get();
        }

        public int select(long timeout) throws IOException {
            if (NioManager.this.selector.keys().isEmpty() || timeout > 0L || timeout < 100L) {
                return super.select(timeout);
            }
            long start = Utils.nanoTime();
            int selected = super.select(timeout);
            if (selected == 0 && !this.wakeupPending()) {
                long end = Utils.nanoTime();
                long duration = TimeUnit.NANOSECONDS.toMillis(end - start);
                if (duration < 50L) {
                    ++this.spins;
                    if (this.spins > 10) {
                        this.reset();
                        this.spins = 0;
                    }
                } else {
                    this.spins = 0;
                }
            } else {
                this.spins = 0;
            }
            return selected;
        }

        private void reset() throws IOException {
            NioManager.this.trace("Selector spin detected... resetting the selector", new Object[0]);
            Selector nextSelector = Selector.open();
            Iterator<SelectionKey> i$ = NioManager.this.selector.keys().iterator();
            while (i$.hasNext()) {
                SelectionKey key = i$.next();
                NioAttachment attachment = (NioAttachment)key.attachment();
                if (key.isValid()) {
                    try {
                        SelectionKey nextKey = key.channel().register(nextSelector, key.interestOps());
                        nextKey.attach(attachment);
                        Iterator<NioDispatchSource> i$2 = attachment.sources.iterator();
                        while (i$2.hasNext()) {
                            NioDispatchSource source = i$2.next();
                            NioDispatchSource.KeyState state = (NioDispatchSource.KeyState)source.keyState.get();
                            if (state == null) continue;
                            state.key = nextKey;
                        }
                        continue;
                    }
                    catch (IOException e) {
                        attachment.cancel(key);
                        continue;
                    }
                }
                attachment.cancel(key);
            }
            NioManager.this.selector.close();
            NioManager.this.selector = nextSelector;
        }
    }

    class SelectStrategy {
        SelectStrategy() {
        }

        public int select(long timeout) throws IOException {
            int rc = 0;
            if (timeout == -1L) {
                NioManager.this.trace("entered blocking select", new Object[0]);
                rc = NioManager.this.selector.select();
                NioManager.this.trace("exited blocking select", new Object[0]);
            } else {
                NioManager.this.trace("entered blocking select with timeout", new Object[0]);
                rc = NioManager.this.selector.select(timeout);
                NioManager.this.trace("exited blocking select with timeout", new Object[0]);
            }
            return rc;
        }
    }
}

