/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.internal.MetricsCollector;

public final class ActiveMetricsCollector
extends MetricsCollector {
    private final DispatchQueue queue;
    private final AtomicLong max_run_time = new AtomicLong();
    private final AtomicLong max_wait_time = new AtomicLong();
    private final AtomicLong enqueued = new AtomicLong();
    private final AtomicLong dequeued = new AtomicLong();
    private final AtomicLong total_run_time = new AtomicLong();
    private final AtomicLong total_wait_time = new AtomicLong();

    public ActiveMetricsCollector(DispatchQueue queue) {
        this.queue = queue;
    }

    private void setMax(AtomicLong holder, long value) {
        long p;
        while (value > (p = holder.get())) {
            if (!holder.compareAndSet(p, value)) continue;
            return;
        }
    }

    public Task track(final Task runnable) {
        this.enqueued.incrementAndGet();
        final long enqueuedAt = Utils.nanoTime();
        return new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                long dequeued_at = Utils.nanoTime();
                long wait_time = dequeued_at - enqueuedAt;
                ActiveMetricsCollector.this.total_wait_time.addAndGet(wait_time);
                ActiveMetricsCollector.this.setMax(ActiveMetricsCollector.this.max_wait_time, wait_time);
                ActiveMetricsCollector.this.dequeued.incrementAndGet();
                long dequeuedAt = dequeued_at;
                try {
                    runnable.run();
                }
                finally {
                    long run_time = Utils.nanoTime() - dequeuedAt;
                    ActiveMetricsCollector.this.total_run_time.addAndGet(run_time);
                    ActiveMetricsCollector.this.setMax(ActiveMetricsCollector.this.max_run_time, run_time);
                }
            }
        };
    }
}

