/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.SslTransport;

public abstract class AbstractProtocolCodec
implements ProtocolCodec {
    protected int writeBufferSize = 65536;
    protected long writeCounter = 0L;
    protected GatheringByteChannel writeChannel = null;
    protected DataByteArrayOutputStream nextWriteBuffer = new DataByteArrayOutputStream(this.writeBufferSize);
    protected long lastWriteIoSize = 0L;
    protected LinkedList<ByteBuffer> writeBuffer = new LinkedList();
    private long writeBufferRemaining = 0L;
    protected long readCounter = 0L;
    protected int readBufferSize = 65536;
    protected ReadableByteChannel readChannel = null;
    protected ByteBuffer readBuffer = ByteBuffer.allocate(this.readBufferSize);
    protected ByteBuffer directReadBuffer = null;
    protected int readEnd;
    protected int readStart;
    protected int lastReadIoSize;
    protected Action nextDecodeAction;
    protected boolean trim = true;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$fusesource$hawtdispatch$transport$AbstractProtocolCodec;

    public void setWritableByteChannel(WritableByteChannel channel) throws SocketException {
        this.writeChannel = (GatheringByteChannel)channel;
        if (this.writeChannel instanceof SocketChannel) {
            this.writeBufferSize = ((SocketChannel)this.writeChannel).socket().getSendBufferSize();
        } else if (this.writeChannel instanceof SslTransport.SSLChannel) {
            this.writeBufferSize = ((SslTransport.SSLChannel)this.writeChannel).socket().getSendBufferSize();
        }
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public boolean full() {
        return this.writeBufferRemaining >= (long)this.writeBufferSize;
    }

    public boolean isEmpty() {
        return this.writeBufferRemaining == 0L && this.nextWriteBuffer.size() == 0;
    }

    public long getWriteCounter() {
        return this.writeCounter;
    }

    protected abstract void encode(Object var1) throws IOException;

    public ProtocolCodec.BufferState write(Object value) throws IOException {
        if (this.full()) {
            return ProtocolCodec.BufferState.FULL;
        }
        boolean wasEmpty = this.isEmpty();
        this.encode(value);
        if (this.nextWriteBuffer.size() >= this.writeBufferSize >> 1) {
            this.flushNextWriteBuffer();
        }
        if (wasEmpty) {
            return ProtocolCodec.BufferState.WAS_EMPTY;
        }
        return ProtocolCodec.BufferState.NOT_EMPTY;
    }

    protected void flushNextWriteBuffer() {
        int nextnextSizesize = Math.min(Math.max(this.nextWriteBuffer.position(), 80), this.writeBufferSize);
        ByteBuffer bb = this.nextWriteBuffer.toBuffer().toByteBuffer();
        this.writeBuffer.add(bb);
        this.writeBufferRemaining += (long)bb.remaining();
        this.nextWriteBuffer = new DataByteArrayOutputStream(nextnextSizesize);
    }

    public ProtocolCodec.BufferState flush() throws IOException {
        block0: while (true) {
            if (this.writeBufferRemaining != 0L) {
                if (this.writeBuffer.size() == 1) {
                    ByteBuffer b = this.writeBuffer.getFirst();
                    this.lastWriteIoSize = this.writeChannel.write(b);
                    if (this.lastWriteIoSize == 0L) {
                        return ProtocolCodec.BufferState.NOT_EMPTY;
                    }
                    this.writeBufferRemaining -= this.lastWriteIoSize;
                    this.writeCounter += this.lastWriteIoSize;
                    if (b.hasRemaining()) continue;
                    this.onBufferFlushed(this.writeBuffer.removeFirst());
                    continue;
                }
                ByteBuffer[] buffers = this.writeBuffer.toArray(new ByteBuffer[this.writeBuffer.size()]);
                this.lastWriteIoSize = this.writeChannel.write(buffers, 0, buffers.length);
                if (this.lastWriteIoSize == 0L) {
                    return ProtocolCodec.BufferState.NOT_EMPTY;
                }
                this.writeBufferRemaining -= this.lastWriteIoSize;
                this.writeCounter += this.lastWriteIoSize;
                while (true) {
                    if (this.writeBuffer.isEmpty() || this.writeBuffer.getFirst().hasRemaining()) continue block0;
                    this.onBufferFlushed(this.writeBuffer.removeFirst());
                }
            }
            if (this.nextWriteBuffer.size() == 0) {
                return ProtocolCodec.BufferState.EMPTY;
            }
            this.flushNextWriteBuffer();
        }
    }

    protected void onBufferFlushed(ByteBuffer byteBuffer) {
    }

    protected abstract Action initialDecodeAction();

    public void setReadableByteChannel(ReadableByteChannel channel) throws SocketException {
        this.readChannel = channel;
        if (this.readChannel instanceof SocketChannel) {
            this.readBufferSize = ((SocketChannel)this.readChannel).socket().getReceiveBufferSize();
        } else if (this.readChannel instanceof SslTransport.SSLChannel) {
            this.writeBufferSize = ((SslTransport.SSLChannel)this.readChannel).socket().getReceiveBufferSize();
        }
        if (this.nextDecodeAction == null) {
            this.nextDecodeAction = this.initialDecodeAction();
        }
    }

    public long getReadCounter() {
        return this.readCounter;
    }

    public Object read() throws IOException {
        Object command = null;
        while (command == null) {
            if (this.directReadBuffer != null) {
                while (this.directReadBuffer.hasRemaining()) {
                    this.lastReadIoSize = this.readChannel.read(this.directReadBuffer);
                    this.readCounter += (long)this.lastReadIoSize;
                    if (this.lastReadIoSize == -1) {
                        throw new EOFException("Peer disconnected");
                    }
                    if (this.lastReadIoSize != 0) continue;
                    return null;
                }
                command = this.nextDecodeAction.apply();
                continue;
            }
            if (this.readEnd == this.readBuffer.position()) {
                if (this.readBuffer.remaining() == 0) {
                    int size = this.readEnd - this.readStart;
                    int newCapacity = 0;
                    newCapacity = this.readStart == 0 ? size + this.readBufferSize : (size > this.readBufferSize ? size + this.readBufferSize : this.readBufferSize);
                    byte[] newnewBufferbuffer = new byte[newCapacity];
                    if (size > 0) {
                        System.arraycopy(this.readBuffer.array(), this.readStart, newnewBufferbuffer, 0, size);
                    }
                    this.readBuffer = ByteBuffer.wrap(newnewBufferbuffer);
                    this.readBuffer.position(size);
                    this.readStart = 0;
                    this.readEnd = size;
                }
                int p = this.readBuffer.position();
                this.lastReadIoSize = this.readChannel.read(this.readBuffer);
                this.readCounter += (long)this.lastReadIoSize;
                if (this.lastReadIoSize == -1) {
                    ++this.readCounter;
                    throw new EOFException("Peer disconnected");
                }
                if (this.lastReadIoSize == 0) {
                    return null;
                }
            }
            command = this.nextDecodeAction.apply();
            if (!$assertionsDisabled && this.readStart > this.readEnd) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.readEnd > this.readBuffer.position()) {
                throw new AssertionError();
            }
        }
        return command;
    }

    static {
        Class<?> clazz = class$org$fusesource$hawtdispatch$transport$AbstractProtocolCodec;
        if (clazz == null) {
            clazz = class$org$fusesource$hawtdispatch$transport$AbstractProtocolCodec = new AbstractProtocolCodec[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static interface Action {
        public Object apply() throws IOException;
    }
}

