/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentLinkedQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.LinkedList;
import net.sf.retrotranslator.runtime.java.util._LinkedList;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.internal.GlobalDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.InactiveMetricsCollector;
import org.fusesource.hawtdispatch.internal.MetricsCollector;
import org.fusesource.hawtdispatch.internal.WorkerThread;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadDispatchQueue
implements HawtDispatchQueue {
    volatile String label;
    final LinkedList<Runnable> localRunnables = new LinkedList();
    final ConcurrentLinkedQueue<Runnable> sharedRunnables = new ConcurrentLinkedQueue();
    final WorkerThread thread;
    final GlobalDispatchQueue globalQueue;
    private MetricsCollector metricsCollector = InactiveMetricsCollector.INSTANCE;
    private final LinkedList<Runnable> sourceQueue = new LinkedList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$fusesource$hawtdispatch$internal$ThreadDispatchQueue;

    public ThreadDispatchQueue(GlobalDispatchQueue globalQueue, WorkerThread thread) {
        this.thread = thread;
        this.globalQueue = globalQueue;
        this.label = new StringBuffer().append(thread.getName()).append(" pritority: ").append(globalQueue.getLabel()).toString();
        this.getDispatcher().track(this);
    }

    @Override
    public LinkedList<Runnable> getSourceQueue() {
        return this.sourceQueue;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean isExecuting() {
        return this.globalQueue.dispatcher.getCurrentThreadQueue() == this;
    }

    @Override
    public void assertExecuting() {
        if (!$assertionsDisabled && !this.isExecuting()) {
            throw new AssertionError((Object)this.getDispatcher().assertMessage());
        }
    }

    @Override
    public HawtDispatcher getDispatcher() {
        return this.globalQueue.dispatcher;
    }

    @Override
    public void execute(Runnable runnable) {
        runnable = this.metricsCollector.track(runnable);
        if (Thread.currentThread() != this.thread) {
            this.sharedRunnables.add((Object)runnable);
            this.thread.unpark();
        } else {
            this.localRunnables.add(runnable);
        }
    }

    public Runnable poll() {
        Runnable rc = (Runnable)_LinkedList.poll(this.localRunnables);
        if (rc == null) {
            rc = (Runnable)this.sharedRunnables.poll();
        }
        return rc;
    }

    @Override
    public void executeAfter(long delay, TimeUnit unit, Runnable runnable) {
        this.getDispatcher().timerThread.addRelative(runnable, this, delay, unit);
    }

    @Override
    public void resume() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspend() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSuspended() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTargetQueue(DispatchQueue queue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HawtDispatchQueue getTargetQueue() {
        return null;
    }

    @Override
    public DispatchQueue.QueueType getQueueType() {
        return DispatchQueue.QueueType.THREAD_QUEUE;
    }

    @Override
    public /* synthetic */ DispatchQueue getTargetQueue() {
        return this.getTargetQueue();
    }

    static {
        Class<?> clazz = class$org$fusesource$hawtdispatch$internal$ThreadDispatchQueue;
        if (clazz == null) {
            clazz = class$org$fusesource$hawtdispatch$internal$ThreadDispatchQueue = new ThreadDispatchQueue[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

