/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.impl;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.asm.FieldVisitor;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.asm.signature.SignatureReader;
import net.sf.retrotranslator.runtime.asm.signature.SignatureVisitor;
import net.sf.retrotranslator.runtime.impl.BytecodeTransformer;
import net.sf.retrotranslator.runtime.impl.FieldDescriptor;
import net.sf.retrotranslator.runtime.impl.GenericDeclarationDescriptor;
import net.sf.retrotranslator.runtime.impl.LazyList;
import net.sf.retrotranslator.runtime.impl.LazyValue;
import net.sf.retrotranslator.runtime.impl.MethodDescriptor;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.runtime.impl.SignatureList;
import net.sf.retrotranslator.runtime.impl.TypeDescriptor;
import net.sf.retrotranslator.runtime.impl.WeakIdentityTable;
import net.sf.retrotranslator.runtime.java.lang._Class;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescriptor
extends GenericDeclarationDescriptor {
    private static final WeakIdentityTable<Class, String> metadataTable = new WeakIdentityTable();
    private static SoftReference<Map<Class, ClassDescriptor>> cache;
    private static BytecodeTransformer bytecodeTransformer;
    private String name;
    private Class target;
    private String declaringClass;
    private String enclosingClass;
    private String enclosingMethod;
    private LazyList<TypeDescriptor, Object> genericInterfaces;
    private LazyValue<TypeDescriptor, Object> genericSuperclass;
    private Map<String, FieldDescriptor> fieldDescriptors = new HashMap<String, FieldDescriptor>();
    private Map<String, MethodDescriptor> methodDescriptors = new HashMap<String, MethodDescriptor>();

    public ClassDescriptor(Class target, byte[] bytecode) {
        this.target = target;
        if (bytecode != null) {
            if (bytecodeTransformer != null) {
                bytecode = bytecodeTransformer.transform(bytecode, 0, bytecode.length);
            }
            new ClassReader(bytecode).accept(this, true);
        } else {
            this.visit(0, target.getModifiers(), Type.getInternalName(target), null, null, null);
        }
    }

    public static ClassDescriptor getInstance(Class target) {
        String s;
        Map<Class, ClassDescriptor> map = ClassDescriptor.getMap();
        ClassDescriptor descriptor = map.get(target);
        if (descriptor != null) {
            return descriptor;
        }
        byte[] bytecode = RuntimeTools.getBytecode(target);
        if (bytecode != null) {
            descriptor = new ClassDescriptor(target, bytecode);
        }
        if ((descriptor == null || descriptor.isMetadataPresent()) && (s = ClassDescriptor.getEncodedMetadata(target)) != null) {
            descriptor = new ClassDescriptor(target, ClassDescriptor.decode(s));
        }
        if (descriptor == null) {
            descriptor = new ClassDescriptor(target, null);
        }
        map.put(target, descriptor);
        return descriptor;
    }

    private static String getEncodedMetadata(Class target) {
        try {
            _Class.forName(target.getName(), true, target.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return metadataTable.lookup(target);
    }

    private static byte[] decode(String s) {
        byte[] bytecode = new byte[s.length()];
        for (int i = 0; i < bytecode.length; ++i) {
            bytecode[i] = (byte)(127 - s.charAt(i));
        }
        return bytecode;
    }

    private boolean isMetadataPresent() {
        for (MethodDescriptor descriptor : this.methodDescriptors.values()) {
            if (!descriptor.isMetadataPresent()) continue;
            return true;
        }
        return false;
    }

    private static synchronized Map<Class, ClassDescriptor> getMap() {
        Map<Class, ClassDescriptor> map;
        Map<Class, ClassDescriptor> map2 = map = cache == null ? null : cache.get();
        if (map == null) {
            map = new Hashtable<Class, ClassDescriptor>();
            cache = new SoftReference<Map<Class, ClassDescriptor>>(map);
        }
        return map;
    }

    @Override
    public ClassDescriptor getClassDescriptor() {
        return this;
    }

    public MethodDescriptor getEnclosingMethodDescriptor() {
        return this.enclosingMethod == null ? null : ClassDescriptor.getInstance(this.getClassByInternalName(this.enclosingClass)).getMethodDescriptor(this.enclosingMethod);
    }

    public MethodDescriptor getMethodDescriptor(String key) {
        return this.methodDescriptors.get(key);
    }

    public Class getTarget() {
        return this.target;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.access = access;
        this.name = name;
        if (signature == null) {
            signature = SignatureList.getSignature(name);
        }
        if (signature != null) {
            new SignatureReader(signature).accept(this);
        }
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        if (name != null) {
            this.enclosingClass = owner;
            this.enclosingMethod = new StringBuffer().append(name).append(desc).toString();
        }
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (name.equals(this.name)) {
            this.access |= access;
            this.declaringClass = outerName;
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldDescriptor fieldDescriptor = new FieldDescriptor(this, access, name, desc, signature);
        this.fieldDescriptors.put(name, fieldDescriptor);
        return fieldDescriptor;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(this, access, name, desc, signature);
        this.methodDescriptors.put(new StringBuffer().append(name).append(desc).toString(), methodDescriptor);
        return methodDescriptor;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (!this.isAccess(512)) {
            this.genericSuperclass = this.getLazyType(descriptor);
        }
        return descriptor;
    }

    @Override
    public SignatureVisitor visitInterface() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (this.genericInterfaces == null) {
            this.genericInterfaces = this.getLazyList();
        }
        this.genericInterfaces.add(descriptor);
        return descriptor;
    }
}

