/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.log4j;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fusesource.insight.log.support.MavenCoordinates;
import org.fusesource.insight.log.support.Strings;

public class MavenCoordHelper {
    private static Map<String, String> classToMavenCoordMap = new ConcurrentHashMap<String, String>();

    public static String getMavenCoordinates(String className) {
        String coordinates = null;
        if (!Strings.isEmpty((String)className) && (coordinates = classToMavenCoordMap.get(className)) == null) {
            try {
                Class cls = MavenCoordHelper.findClass(className);
                coordinates = MavenCoordHelper.getMavenCoordinates(cls);
            }
            catch (Throwable t) {
                System.out.println("Ignored: " + t);
            }
        }
        return coordinates;
    }

    public static String getMavenCoordinates(Class cls) throws IOException {
        String implVersion;
        StringBuilder buffer = new StringBuilder();
        try {
            URL locationURL;
            CodeSource source = cls.getProtectionDomain().getCodeSource();
            if (source != null && (locationURL = source.getLocation()) != null) {
                if ("file".equals(locationURL.getProtocol())) {
                    String path = locationURL.getPath();
                    if (path != null) {
                        String coordinates;
                        File file = new File(path);
                        if (file.exists() && !Strings.isEmpty((String)(coordinates = MavenCoordinates.mavenCoordinatesFromJarFile((File)file)))) {
                            return coordinates;
                        }
                        int lastSlash = path.lastIndexOf(47);
                        int lastBack = path.lastIndexOf(File.separatorChar);
                        if (lastBack > lastSlash) {
                            lastSlash = lastBack;
                        }
                        if (lastSlash <= 0 || lastSlash == path.length() - 1) {
                            buffer.append(locationURL);
                        } else {
                            buffer.append(path.substring(lastSlash + 1));
                        }
                    }
                } else {
                    buffer.append(locationURL);
                }
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        buffer.append(':');
        Package pkg = cls.getPackage();
        if (pkg != null && (implVersion = pkg.getImplementationVersion()) != null) {
            buffer.append(implVersion);
        }
        return buffer.toString();
    }

    protected static Class findClass(String className) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                return MavenCoordHelper.class.getClassLoader().loadClass(className);
            }
        }
    }
}

