/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.util.BaseOutputWriter;
import com.googlecode.jmxtrans.util.JmxUtils;
import com.googlecode.jmxtrans.util.ValidationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.jrobin.core.ArcDef;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdDefTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRDToolWriter
extends BaseOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(RRDToolWriter.class);
    private File outputFile = null;
    private File templateFile = null;
    private File binaryPath = null;
    public static final String GENERATE = "generate";
    private static final char[] INITIALS = new char[]{' ', '.'};

    @Override
    public void validateSetup(Query query) throws ValidationException {
        this.outputFile = new File((String)this.getSettings().get("outputFile"));
        this.templateFile = new File((String)this.getSettings().get("templateFile"));
        this.binaryPath = new File((String)this.getSettings().get("binaryPath"));
        if (this.outputFile == null || this.templateFile == null || this.binaryPath == null) {
            throw new ValidationException("output, template and binary path file can't be null", query);
        }
    }

    public String getDataSourceName(String typeName, String attributeName, String entry) {
        String result = null;
        result = typeName != null ? typeName + attributeName + entry : attributeName + entry;
        if (attributeName.length() > 15) {
            Object[] split = StringUtils.splitByCharacterTypeCamelCase((String)attributeName);
            String join = StringUtils.join((Object[])split, (char)'.');
            attributeName = WordUtils.initials((String)join, (char[])INITIALS);
        }
        result = attributeName + DigestUtils.md5Hex((String)result);
        result = StringUtils.left((String)result, (int)19);
        return result;
    }

    @Override
    public void doWrite(Query query) throws Exception {
        RrdDef def = this.getDatabaseTemplateSpec();
        List<String> dsNames = this.getDsNames(def.getDsDefs());
        List<Result> results = query.getResults();
        TreeMap<String, String> dataMap = new TreeMap<String, String>();
        for (Result res : results) {
            log.debug(res.toString());
            Map<String, Object> values = res.getValues();
            if (values == null) continue;
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                String key = this.getDataSourceName(this.getConcatedTypeNameValues(res.getTypeName()), res.getAttributeName(), entry.getKey());
                boolean isNumeric = JmxUtils.isNumeric(entry.getValue());
                if (this.isDebugEnabled() && isNumeric) {
                    log.debug("Generated DataSource name:value: " + key + " : " + entry.getValue());
                }
                if (!dsNames.contains(key) || !isNumeric) continue;
                dataMap.put(key, entry.getValue().toString());
            }
        }
        this.doGenerate(results);
        if (dataMap.keySet().size() > 0 && dataMap.values().size() > 0) {
            this.rrdToolUpdate(StringUtils.join(dataMap.keySet(), (char)':'), StringUtils.join(dataMap.values(), (char)':'));
        } else {
            log.error("Nothing was logged for query: " + query);
        }
    }

    private void doGenerate(List<Result> results) throws Exception {
        if (this.isDebugEnabled() && this.getBooleanSetting(GENERATE)) {
            StringBuilder sb = new StringBuilder("\n");
            ArrayList<String> keys = new ArrayList<String>();
            for (Result res : results) {
                Map<String, Object> values = res.getValues();
                if (values == null) continue;
                for (Map.Entry<String, Object> entry : values.entrySet()) {
                    boolean isNumeric = JmxUtils.isNumeric(entry.getValue());
                    if (!isNumeric) continue;
                    String key = this.getDataSourceName(this.getConcatedTypeNameValues(res.getTypeName()), res.getAttributeName(), entry.getKey());
                    if (keys.contains(key)) {
                        throw new Exception("Duplicate datasource name found: '" + key + "'. Please try to add more typeName keys to the writer to make the name more unique. " + res.toString());
                    }
                    keys.add(key);
                    sb.append("<datasource><!-- " + res.getTypeName() + ":" + res.getAttributeName() + ":" + entry.getKey() + " --><name>" + key + "</name><type>GAUGE</type><heartbeat>400</heartbeat><min>U</min><max>U</max></datasource>\n");
                }
            }
            log.debug(sb.toString());
        }
    }

    protected void rrdToolUpdate(String template, String data) throws Exception {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.binaryPath + "/rrdtool");
        commands.add("update");
        commands.add(this.outputFile.getCanonicalPath());
        commands.add("-t");
        commands.add(template);
        commands.add("N:" + data);
        ProcessBuilder pb = new ProcessBuilder(commands);
        Process process = pb.start();
        this.checkErrorStream(process);
    }

    protected RrdDef getDatabaseTemplateSpec() throws Exception {
        RrdDefTemplate t = new RrdDefTemplate(this.templateFile);
        t.setVariable("database", this.outputFile.getCanonicalPath());
        RrdDef def = t.getRrdDef();
        if (!this.outputFile.exists()) {
            FileUtils.forceMkdir((File)this.outputFile.getParentFile());
            this.rrdToolCreateDatabase(def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rrdToolCreateDatabase(RrdDef def) throws Exception {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.binaryPath + "/rrdtool");
        commands.add("create");
        commands.add(this.outputFile.getCanonicalPath());
        commands.add("-s");
        commands.add(String.valueOf(def.getStep()));
        for (DsDef dsDef : def.getDsDefs()) {
            commands.add(this.getDsDefStr(dsDef));
        }
        for (DsDef dsDef : def.getArcDefs()) {
            commands.add(this.getRraStr((ArcDef)dsDef));
        }
        ProcessBuilder pb = new ProcessBuilder(commands);
        Process process = pb.start();
        try {
            this.checkErrorStream(process);
        }
        finally {
            IOUtils.closeQuietly((InputStream)process.getInputStream());
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            IOUtils.closeQuietly((InputStream)process.getErrorStream());
        }
    }

    private void checkErrorStream(Process process) throws Exception {
        InputStream is = process.getErrorStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        if (sb.length() > 0) {
            throw new RuntimeException(sb.toString());
        }
    }

    private String getRraStr(ArcDef def) {
        return "RRA:" + def.getConsolFun() + ":" + def.getXff() + ":" + def.getSteps() + ":" + def.getRows();
    }

    private String getDsDefStr(DsDef def) {
        return "DS:" + def.getDsName() + ":" + def.getDsType() + ":" + def.getHeartbeat() + ":" + this.formatDouble(def.getMinValue()) + ":" + this.formatDouble(def.getMaxValue());
    }

    private List<String> getDsNames(DsDef[] defs) {
        ArrayList<String> names = new ArrayList<String>();
        for (DsDef def : defs) {
            names.add(def.getDsName());
        }
        return names;
    }

    private String formatDouble(double dbl) {
        if (Double.isNaN(dbl)) {
            return "U";
        }
        return String.valueOf(dbl);
    }
}

