/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.util.DatagramSocketFactory;
import com.googlecode.jmxtrans.util.JmxConnectionFactory;
import com.googlecode.jmxtrans.util.PropertyResolver;
import com.googlecode.jmxtrans.util.SocketFactory;
import com.googlecode.jmxtrans.util.ValidationException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(value={"alias", "local", "host", "port", "username", "password", "cronExpression", "numQueryThreads", "protocolProviderPackages"})
public class Server {
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    private static final String FRONT = "service:jmx:rmi:///jndi/rmi://";
    private static final String BACK = "/jmxrmi";
    public static final String SOCKET_FACTORY_POOL = SocketFactory.class.getSimpleName();
    public static final String JMX_CONNECTION_FACTORY_POOL = JmxConnectionFactory.class.getSimpleName();
    public static final String DATAGRAM_SOCKET_FACTORY_POOL = DatagramSocketFactory.class.getSimpleName();
    private JmxProcess jmxProcess;
    private String alias;
    private String host;
    private String port;
    private String username;
    private String password;
    private String protocolProviderPackages;
    private String url;
    private String cronExpression;
    private Integer numQueryThreads;
    private boolean local;
    private MBeanServer localMBeanServer;
    private List<Query> queries = new ArrayList<Query>();

    public Server() {
    }

    public Server(String host, String port) {
        this.host = host;
        this.port = port;
    }

    public Server(String host, String port, Query query) throws ValidationException {
        this.host = host;
        this.port = port;
        this.addQuery(query);
    }

    public void setJmxProcess(JmxProcess jmxProcess) {
        this.jmxProcess = jmxProcess;
    }

    @JsonIgnore
    public JmxProcess getJmxProcess() {
        return this.jmxProcess;
    }

    @JsonIgnore
    public MBeanServer getLocalMBeanServer() {
        if (this.localMBeanServer == null) {
            this.localMBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return this.localMBeanServer;
    }

    public void setLocalMBeanServer(MBeanServer localMBeanServer) {
        this.localMBeanServer = localMBeanServer;
    }

    public void setAlias(String alias) {
        this.alias = PropertyResolver.resolveProps(alias);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setHost(String host) {
        this.host = PropertyResolver.resolveProps(host);
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(String port) {
        this.port = PropertyResolver.resolveProps(port);
    }

    public String getPort() {
        return this.port;
    }

    public void setUsername(String username) {
        this.username = PropertyResolver.resolveProps(username);
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = PropertyResolver.resolveProps(password);
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public void setQueries(List<Query> queries) throws ValidationException {
        for (Query q : queries) {
            this.addQuery(q);
        }
    }

    public List<Query> getQueries() {
        return this.queries;
    }

    public void addQuery(Query q) throws ValidationException {
        if (!this.queries.contains(q)) {
            this.queries.add(q);
        } else {
            log.debug("Skipped duplicate query: " + q + " for server: " + this);
        }
    }

    @JsonIgnore
    public String getUrl() {
        if (this.url == null) {
            if (this.host == null || this.port == null) {
                throw new RuntimeException("url is null and host or port is null. cannot construct url dynamically.");
            }
            this.url = FRONT + this.host + ":" + this.port + BACK;
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = PropertyResolver.resolveProps(url);
    }

    @JsonIgnore
    public List<Result> getResults() {
        List<Query> queries = this.getQueries();
        ArrayList<Result> results = null;
        if (queries != null) {
            results = new ArrayList<Result>();
            for (Query q : queries) {
                List<Result> tmp = q.getResults();
                if (tmp == null) continue;
                results.addAll(tmp);
            }
        }
        return results;
    }

    @JsonIgnore
    public boolean isQueriesMultiThreaded() {
        return this.numQueryThreads != null && this.numQueryThreads > 0;
    }

    public void setNumQueryThreads(Integer numQueryThreads) {
        this.numQueryThreads = numQueryThreads;
    }

    public Integer getNumQueryThreads() {
        return this.numQueryThreads;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String toString() {
        return "Server [host=" + this.host + ", port=" + this.port + ", url=" + this.url + ", cronExpression=" + this.cronExpression + ", numQueryThreads=" + this.numQueryThreads + "]";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        return new EqualsBuilder().append((Object)this.getHost(), (Object)other.getHost()).append((Object)this.getPort(), (Object)other.getPort()).append((Object)this.getNumQueryThreads(), (Object)other.getNumQueryThreads()).append((Object)this.getCronExpression(), (Object)other.getCronExpression()).append((Object)this.getAlias(), (Object)other.getAlias()).append((Object)this.getUsername(), (Object)other.getUsername()).append((Object)this.getPassword(), (Object)other.getPassword()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 21).append((Object)this.getHost()).append((Object)this.getPort()).append((Object)this.getNumQueryThreads()).append((Object)this.getCronExpression()).append((Object)this.getAlias()).append((Object)this.getUsername()).append((Object)this.getPassword()).toHashCode();
    }

    public String getProtocolProviderPackages() {
        return this.protocolProviderPackages;
    }

    public void setProtocolProviderPackages(String protocolProviderPackages) {
        this.protocolProviderPackages = protocolProviderPackages;
    }
}

