/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.googlecode.jmxtrans.model.Server;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class JmxProcess {
    private String name;
    private List<Server> servers = new ArrayList<Server>();
    private Integer numMultiThreadedServers;

    public JmxProcess() {
    }

    public JmxProcess(Server server) {
        this.addServer(server);
    }

    public JmxProcess(List<Server> servers) {
        this.setServers(servers);
    }

    public void setServers(List<Server> servers) {
        this.servers = servers;
        for (Server server : this.servers) {
            server.setJmxProcess(this);
        }
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public void addServer(Server server) {
        server.setJmxProcess(this);
        this.servers.add(server);
    }

    @JsonIgnore
    public boolean isServersMultiThreaded() {
        return this.numMultiThreadedServers != null && this.numMultiThreadedServers > 0;
    }

    public void setNumMultiThreadedServers(Integer numMultiThreadedServers) {
        this.numMultiThreadedServers = numMultiThreadedServers;
    }

    public Integer getNumMultiThreadedServers() {
        return this.numMultiThreadedServers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

