/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.util;

import com.googlecode.jmxtrans.OutputWriter;
import com.googlecode.jmxtrans.util.JmxUtils;
import com.googlecode.jmxtrans.util.LifecycleException;
import com.googlecode.jmxtrans.util.PropertyResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.pool.KeyedObjectPool;
import org.codehaus.jackson.annotate.JsonIgnore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseOutputWriter
implements OutputWriter {
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String OUTPUT_FILE = "outputFile";
    public static final String TEMPLATE_FILE = "templateFile";
    public static final String BINARY_PATH = "binaryPath";
    public static final String DEBUG = "debug";
    public static final String TYPE_NAMES = "typeNames";
    private Boolean debugEnabled = null;
    private Map<String, Object> settings;

    public void addSetting(String key, Object value) {
        this.getSettings().put(key, value);
    }

    @Override
    public Map<String, Object> getSettings() {
        if (this.settings == null) {
            this.settings = new TreeMap<String, Object>();
        }
        return this.settings;
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.settings = settings;
        PropertyResolver.resolveMap(this.settings);
    }

    public boolean getBooleanSetting(String key) {
        Boolean result = null;
        if (this.getSettings().containsKey(key)) {
            Object foo = this.getSettings().get(key);
            if (foo instanceof String) {
                result = Boolean.valueOf((String)foo);
            } else if (foo instanceof Boolean) {
                result = (Boolean)foo;
            }
        }
        return result != null ? result : false;
    }

    @JsonIgnore
    public boolean isDebugEnabled() {
        if (this.debugEnabled == null) {
            return this.getBooleanSetting(DEBUG);
        }
        return this.debugEnabled != null ? this.debugEnabled : false;
    }

    public void setTypeNames(List<String> typeNames) {
        this.getSettings().put(TYPE_NAMES, typeNames);
    }

    @JsonIgnore
    public List<String> getTypeNames() {
        if (!this.getSettings().containsKey(TYPE_NAMES)) {
            ArrayList tmp = new ArrayList();
            this.getSettings().put(TYPE_NAMES, tmp);
        }
        return (List)this.getSettings().get(TYPE_NAMES);
    }

    public void addTypeName(String str) {
        this.getTypeNames().add(str);
    }

    protected String getConcatedTypeNameValues(String typeNameStr) {
        return JmxUtils.getConcatedTypeNameValues(this.getTypeNames(), typeNameStr);
    }

    protected String cleanupStr(String name) {
        return JmxUtils.cleanupStr(name);
    }

    @Override
    public void setObjectPoolMap(Map<String, KeyedObjectPool> poolMap) {
    }

    @Override
    public void start() throws LifecycleException {
    }

    @Override
    public void stop() throws LifecycleException {
    }
}

