/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.util.BaseOutputWriter;
import com.googlecode.jmxtrans.util.JmxUtils;
import com.googlecode.jmxtrans.util.ValidationException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdDefTemplate;
import org.jrobin.core.Sample;

public class RRDWriter
extends BaseOutputWriter {
    private File outputFile = null;
    private File templateFile = null;

    public void validateSetup(Query query) throws ValidationException {
        this.outputFile = new File((String)this.getSettings().get("outputFile"));
        this.templateFile = new File((String)this.getSettings().get("templateFile"));
        if (this.outputFile == null || this.templateFile == null) {
            throw new ValidationException("output file and template file can't be null", query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWrite(Query query) throws Exception {
        RrdDb db = null;
        try {
            db = this.createOrOpenDatabase();
            Sample sample = db.createSample();
            List<String> dsNames = Arrays.asList(db.getDsNames());
            List<Result> results = query.getResults();
            for (Result res : results) {
                Map<String, Object> values = res.getValues();
                if (values == null) continue;
                for (Map.Entry<String, Object> entry : values.entrySet()) {
                    if (!dsNames.contains(entry.getKey()) || !JmxUtils.isNumeric(entry.getValue())) continue;
                    sample.setValue(entry.getKey(), Double.valueOf(entry.getValue().toString()).doubleValue());
                }
            }
            sample.update();
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    protected RrdDb createOrOpenDatabase() throws Exception {
        RrdDb result = null;
        if (!this.outputFile.exists()) {
            FileUtils.forceMkdir((File)this.outputFile.getParentFile());
            RrdDefTemplate t = new RrdDefTemplate(this.templateFile);
            t.setVariable("database", this.outputFile.getCanonicalPath());
            RrdDef def = t.getRrdDef();
            result = new RrdDb(def);
        } else {
            result = new RrdDb(this.outputFile.getCanonicalPath());
        }
        return result;
    }
}

