/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import java.io.StreamCorruptedException;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.handler.codec.frame.FrameDecoder;

public class SizeHeaderFrameDecoder
extends FrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 4) {
            return null;
        }
        int dataLen = buffer.getInt(buffer.readerIndex());
        if (dataLen <= 0) {
            throw new StreamCorruptedException("invalid data length: " + dataLen);
        }
        if (buffer.readableBytes() < dataLen + 4) {
            return null;
        }
        buffer.skipBytes(4);
        return buffer;
    }
}

