/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.index.mapper.FieldMapper;

public class FieldLookup {
    private final FieldMapper mapper;
    private Document doc;
    private Object value;
    private boolean valueLoaded = false;
    private List<Object> values = new ArrayList<Object>();
    private boolean valuesLoaded = false;

    FieldLookup(FieldMapper mapper) {
        this.mapper = mapper;
    }

    public FieldMapper mapper() {
        return this.mapper;
    }

    public Document doc() {
        return this.doc;
    }

    public void doc(Document doc) {
        this.doc = doc;
    }

    public void clear() {
        this.value = null;
        this.valueLoaded = false;
        this.values.clear();
        this.valuesLoaded = true;
        this.doc = null;
    }

    public boolean isEmpty() {
        if (this.valueLoaded) {
            return this.value == null;
        }
        if (this.valuesLoaded) {
            return this.values.isEmpty();
        }
        return this.getValue() == null;
    }

    public Object getValue() {
        if (this.valueLoaded) {
            return this.value;
        }
        this.valueLoaded = true;
        this.value = null;
        Fieldable field = this.doc.getFieldable(this.mapper.names().indexName());
        if (field == null) {
            return null;
        }
        this.value = this.mapper.value(field);
        return this.value;
    }

    public List<Object> getValues() {
        Fieldable[] fields;
        if (this.valuesLoaded) {
            return this.values;
        }
        this.valuesLoaded = true;
        this.values.clear();
        for (Fieldable field : fields = this.doc.getFieldables(this.mapper.names().indexName())) {
            this.values.add(this.mapper.value(field));
        }
        return this.values;
    }
}

