/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.node.stats;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestNodesStatsAction
extends BaseRestHandler {
    @Inject
    public RestNodesStatsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/nodes/stats", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/nodes/{nodeId}/stats", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String[] nodesIds = RestActions.splitNodes(request.param("nodeId"));
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(nodesIds);
        nodesStatsRequest.listenerThreaded(false);
        this.client.admin().cluster().nodesStats(nodesStatsRequest, new ActionListener<NodesStatsResponse>(){

            @Override
            public void onResponse(NodesStatsResponse result) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("cluster_name", result.clusterName().value());
                    builder.startObject("nodes");
                    for (NodeStats nodeStats : result) {
                        builder.startObject(nodeStats.node().id(), XContentBuilder.FieldCaseConversion.NONE);
                        builder.field("name", nodeStats.node().name());
                        if (nodeStats.indices() != null) {
                            nodeStats.indices().toXContent(builder, request);
                        }
                        if (nodeStats.os() != null) {
                            nodeStats.os().toXContent(builder, request);
                        }
                        if (nodeStats.process() != null) {
                            nodeStats.process().toXContent(builder, request);
                        }
                        if (nodeStats.jvm() != null) {
                            nodeStats.jvm().toXContent(builder, request);
                        }
                        if (nodeStats.network() != null) {
                            nodeStats.network().toXContent(builder, request);
                        }
                        if (nodeStats.transport() != null) {
                            nodeStats.transport().toXContent(builder, request);
                        }
                        builder.endObject();
                    }
                    builder.endObject();
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestNodesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

