/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.pojo;

import java.io.UnsupportedEncodingException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.internal.InternalNode;
import org.fusesource.fabric.groups.Group;
import org.fusesource.fabric.groups.ZooKeeperGroupFactory;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class NodeFactory
implements ManagedServiceFactory {
    private BundleContext bundleContext;
    private Map<String, String> settings;
    private Map<String, Node> nodes = new HashMap<String, Node>();
    private Map<String, ServiceRegistration> services = new HashMap<String, ServiceRegistration>();
    private boolean destroyed = false;
    private IZKClient zookeeper;
    private List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private Group group;
    private String eid;

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public IZKClient getZookeeper() {
        return this.zookeeper;
    }

    public void setZookeeper(IZKClient zookeeper) {
        this.zookeeper = zookeeper;
    }

    public List<ACL> getAcl() {
        return this.acl;
    }

    public void setAcl(List<ACL> acl) {
        this.acl = acl;
    }

    public String getName() {
        return "ElasticSearch Node factory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updated(String pid, Dictionary properties) throws ConfigurationException {
        block12: {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(InternalNode.class.getClassLoader());
                this.deleted(pid);
                if (properties == null || this.destroyed) break block12;
                ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder();
                builder.put(this.settings);
                if (properties != null) {
                    Enumeration e = properties.keys();
                    while (e.hasMoreElements()) {
                        String key = e.nextElement().toString();
                        Object oval = properties.get(key);
                        String val = oval != null ? oval.toString() : null;
                        builder.put(key, val);
                    }
                }
                InternalNode node = new InternalNode(builder.build(), false);
                node.start();
                node.client().admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().execute().actionGet();
                this.services.put(pid, this.bundleContext.registerService(Node.class.getName(), (Object)node, null));
                this.nodes.put(pid, node);
                String fabricUrl = null;
                if (node instanceof InternalNode) {
                    InternalNode in = node;
                    try {
                        HttpServerTransport transport = in.injector().getInstance(HttpServerTransport.class);
                        TransportAddress published = transport.boundAddress().publishAddress();
                        if (published instanceof InetSocketTransportAddress) {
                            InetSocketTransportAddress address = (InetSocketTransportAddress)published;
                            fabricUrl = "http://" + address.address().getAddress().getHostAddress() + ":" + address.address().getPort();
                        }
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
                if (fabricUrl == null) break block12;
                if (this.group == null) {
                    this.group = ZooKeeperGroupFactory.create((IZKClient)this.zookeeper, (String)"/fabric/registry/clusters/elastic-search", this.acl);
                }
                try {
                    this.eid = this.group.join(fabricUrl.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    public synchronized void deleted(String pid) {
        Node node = this.nodes.remove(pid);
        if (node != null) {
            ServiceRegistration reg;
            if (this.group != null) {
                this.group.leave(this.eid);
            }
            if ((reg = this.services.remove(pid)) != null) {
                reg.unregister();
            }
            node.close();
        }
    }

    public synchronized void destroy() {
        this.destroyed = true;
        while (!this.nodes.isEmpty()) {
            String pid = this.nodes.keySet().iterator().next();
            this.deleted(pid);
        }
        if (this.group != null) {
            this.group.close();
        }
    }
}

