/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldData;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldDataType;

public class GeoBoundingBoxFilter
extends Filter {
    private final Point topLeft;
    private final Point bottomRight;
    private final String fieldName;
    private final FieldDataCache fieldDataCache;

    public GeoBoundingBoxFilter(Point topLeft, Point bottomRight, String fieldName, FieldDataCache fieldDataCache) {
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
        this.fieldName = fieldName;
        this.fieldDataCache = fieldDataCache;
    }

    public Point topLeft() {
        return this.topLeft;
    }

    public Point bottomRight() {
        return this.bottomRight;
    }

    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final GeoPointFieldData fieldData = (GeoPointFieldData)this.fieldDataCache.cache(GeoPointFieldDataType.TYPE, reader, this.fieldName);
        if (this.topLeft.lon > this.bottomRight.lon) {
            return new GetDocSet(reader.maxDoc()){

                @Override
                public boolean isCacheable() {
                    return false;
                }

                @Override
                public boolean get(int doc) throws IOException {
                    if (!fieldData.hasValue(doc)) {
                        return false;
                    }
                    if (fieldData.multiValued()) {
                        double[] lats = fieldData.latValues(doc);
                        double[] lons = fieldData.lonValues(doc);
                        for (int i = 0; i < lats.length; ++i) {
                            double lat = lats[i];
                            double lon = lons[i];
                            if (!(((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).topLeft.lon <= lon && 180.0 >= lon) && (!(-180.0 <= lon) || !(((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).bottomRight.lon >= lon)) || !(((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).topLeft.lat >= lat) || !(((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).bottomRight.lat <= lat)) continue;
                            return true;
                        }
                    } else {
                        double lat = fieldData.latValue(doc);
                        double lon = fieldData.lonValue(doc);
                        if ((((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).topLeft.lon <= lon && 180.0 >= lon || -180.0 <= lon && ((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).bottomRight.lon >= lon) && ((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).topLeft.lat >= lat && ((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).bottomRight.lat <= lat) {
                            return true;
                        }
                    }
                    return false;
                }
            };
        }
        return new GetDocSet(reader.maxDoc()){

            @Override
            public boolean isCacheable() {
                return false;
            }

            @Override
            public boolean get(int doc) throws IOException {
                if (!fieldData.hasValue(doc)) {
                    return false;
                }
                if (fieldData.multiValued()) {
                    double[] lats = fieldData.latValues(doc);
                    double[] lons = fieldData.lonValues(doc);
                    for (int i = 0; i < lats.length; ++i) {
                        if (!(((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).topLeft.lon <= lons[i]) || !(((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).bottomRight.lon >= lons[i]) || !(((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).topLeft.lat >= lats[i]) || !(((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).bottomRight.lat <= lats[i])) continue;
                        return true;
                    }
                } else {
                    double lat = fieldData.latValue(doc);
                    double lon = fieldData.lonValue(doc);
                    if (((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).topLeft.lon <= lon && ((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).bottomRight.lon >= lon && ((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).topLeft.lat >= lat && ((GeoBoundingBoxFilter)GeoBoundingBoxFilter.this).bottomRight.lat <= lat) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static class Point {
        public double lat;
        public double lon;
    }
}

