/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseFilterBuilder;

public class TermsFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private final Object[] values;
    private Boolean cache;
    private String filterName;

    public TermsFilterBuilder(String name, String ... values) {
        this(name, (Object[])values);
    }

    public TermsFilterBuilder(String name, int ... values) {
        this.name = name;
        this.values = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public TermsFilterBuilder(String name, long ... values) {
        this.name = name;
        this.values = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public TermsFilterBuilder(String name, float ... values) {
        this.name = name;
        this.values = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = Float.valueOf(values[i]);
        }
    }

    public TermsFilterBuilder(String name, double ... values) {
        this.name = name;
        this.values = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public TermsFilterBuilder(String name, Object ... values) {
        this.name = name;
        this.values = values;
    }

    public TermsFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public TermsFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("terms");
        builder.startArray(this.name);
        for (Object value : this.values) {
            builder.value(value);
        }
        builder.endArray();
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        builder.endObject();
    }
}

