/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseFilterBuilder;

public class IdsFilterBuilder
extends BaseFilterBuilder {
    private String type;
    private List<String> values = new ArrayList<String>();
    private String filterName;

    public IdsFilterBuilder(String type) {
        this.type = type;
    }

    public IdsFilterBuilder addIds(String ... ids) {
        this.values.addAll(Arrays.asList(ids));
        return this;
    }

    public IdsFilterBuilder ids(String ... ids) {
        return this.addIds(ids);
    }

    public IdsFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("ids");
        builder.field("type", this.type);
        builder.startArray("values");
        for (String value : this.values) {
            builder.value((Object)value);
        }
        builder.endArray();
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        builder.endObject();
    }
}

