/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.type.child.HasChildFilter;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.search.internal.SearchContext;

public class HasChildQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "has_child";

    @Inject
    public HasChildQueryParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query query = null;
        float boost = 1.0f;
        String childType = null;
        String scope = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"query".equals(currentFieldName)) continue;
                query = parseContext.parseInnerQuery();
                continue;
            }
            if (!token.isValue()) continue;
            if ("type".equals(currentFieldName)) {
                childType = parser.text();
                continue;
            }
            if (!"_scope".equals(currentFieldName)) continue;
            scope = parser.text();
        }
        if (query == null) {
            throw new QueryParsingException(this.index, "[has_child] requires 'query' field");
        }
        if (childType == null) {
            throw new QueryParsingException(this.index, "[has_child] requires 'type' field");
        }
        DocumentMapper childDocMapper = parseContext.mapperService().documentMapper(childType);
        if (childDocMapper == null) {
            throw new QueryParsingException(this.index, "[has_child] No mapping for for type [" + childType + "]");
        }
        if (childDocMapper.parentFieldMapper() == null) {
            throw new QueryParsingException(this.index, "[has_child]  Type [" + childType + "] does not have parent mapping");
        }
        String parentType = childDocMapper.parentFieldMapper().type();
        query.setBoost(boost);
        query = new FilteredQuery(query, parseContext.cacheFilter(childDocMapper.typeFilter()));
        SearchContext searchContext = SearchContext.current();
        HasChildFilter childFilter = new HasChildFilter(query, scope, childType, parentType, searchContext);
        ConstantScoreQuery childQuery = new ConstantScoreQuery(childFilter);
        childQuery.setBoost(boost);
        searchContext.addScopePhase(childFilter);
        return childQuery;
    }
}

