/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.queryParser.MapperQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserSettings;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.query.parser.QueryParserCache;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;

public class FieldQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "field";
    private final AnalysisService analysisService;
    private final QueryParserCache queryParserCache;

    @Inject
    public FieldQueryParser(Index index, @IndexSettings Settings settings, AnalysisService analysisService, QueryParserCache queryParserCache) {
        super(index, settings);
        this.analysisService = analysisService;
        this.queryParserCache = queryParserCache;
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        String fieldName = parser.currentName();
        QueryParserSettings qpSettings = new QueryParserSettings();
        qpSettings.defaultField(fieldName);
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (!token.isValue()) continue;
                if ("query".equals(currentFieldName)) {
                    qpSettings.queryString(parser.text());
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    qpSettings.boost(parser.floatValue());
                    continue;
                }
                if ("enable_position_increments".equals(currentFieldName) || "enablePositionIncrements".equals(currentFieldName)) {
                    qpSettings.enablePositionIncrements(parser.booleanValue());
                    continue;
                }
                if ("allow_leading_wildcard".equals(currentFieldName) || "allowLeadingWildcard".equals(currentFieldName)) {
                    qpSettings.allowLeadingWildcard(parser.booleanValue());
                    continue;
                }
                if ("lowercase_expanded_terms".equals(currentFieldName) || "lowercaseExpandedTerms".equals(currentFieldName)) {
                    qpSettings.lowercaseExpandedTerms(parser.booleanValue());
                    continue;
                }
                if ("phrase_slop".equals(currentFieldName) || "phraseSlop".equals(currentFieldName)) {
                    qpSettings.phraseSlop(parser.intValue());
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    qpSettings.analyzer(this.analysisService.analyzer(parser.text()));
                    continue;
                }
                if ("default_operator".equals(currentFieldName) || "defaultOperator".equals(currentFieldName)) {
                    String op = parser.text();
                    if ("or".equalsIgnoreCase(op)) {
                        qpSettings.defaultOperator(QueryParser.Operator.OR);
                        continue;
                    }
                    if ("and".equalsIgnoreCase(op)) {
                        qpSettings.defaultOperator(QueryParser.Operator.AND);
                        continue;
                    }
                    throw new QueryParsingException(this.index, "Query default operator [" + op + "] is not allowed");
                }
                if ("fuzzy_min_sim".equals(currentFieldName) || "fuzzyMinSim".equals(currentFieldName)) {
                    qpSettings.fuzzyMinSim(parser.floatValue());
                    continue;
                }
                if ("fuzzy_prefix_length".equals(currentFieldName) || "fuzzyPrefixLength".equals(currentFieldName)) {
                    qpSettings.fuzzyPrefixLength(parser.intValue());
                    continue;
                }
                if ("escape".equals(currentFieldName)) {
                    qpSettings.escape(parser.booleanValue());
                    continue;
                }
                if (!"analyze_wildcard".equals(currentFieldName) && !"analyzeWildcard".equals(currentFieldName)) continue;
                qpSettings.analyzeWildcard(parser.booleanValue());
            }
            parser.nextToken();
        } else {
            qpSettings.queryString(parser.text());
            parser.nextToken();
        }
        if (qpSettings.analyzer() == null) {
            qpSettings.analyzer(parseContext.mapperService().searchAnalyzer());
        }
        if (qpSettings.queryString() == null) {
            throw new QueryParsingException(this.index, "No value specified for term query");
        }
        if (qpSettings.escape()) {
            qpSettings.queryString(QueryParser.escape(qpSettings.queryString()));
        }
        if ((query = this.queryParserCache.get(qpSettings)) != null) {
            return query;
        }
        MapperQueryParser queryParser = parseContext.singleQueryParser(qpSettings);
        try {
            query = queryParser.parse(qpSettings.queryString());
            query.setBoost(qpSettings.boost());
            query = Queries.optimizeQuery(Queries.fixNegativeQueryIfNeeded(query));
            this.queryParserCache.put(qpSettings, query);
            return query;
        }
        catch (ParseException e) {
            throw new QueryParsingException(this.index, "Failed to parse query [" + qpSettings.queryString() + "]", e);
        }
    }
}

