/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;
import org.elasticsearch.index.query.xcontent.XContentQueryBuilder;

public class DisMaxQueryBuilder
extends BaseQueryBuilder {
    private ArrayList<XContentQueryBuilder> queries = Lists.newArrayList();
    private float boost = -1.0f;
    private float tieBreaker = -1.0f;

    public DisMaxQueryBuilder add(XContentQueryBuilder queryBuilder) {
        this.queries.add(queryBuilder);
        return this;
    }

    public DisMaxQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public DisMaxQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("dis_max");
        if (this.tieBreaker != -1.0f) {
            builder.field("tie_breaker", this.tieBreaker);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.startArray("queries");
        for (XContentQueryBuilder queryBuilder : this.queries) {
            queryBuilder.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
    }
}

