/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.scheduler;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.TrackingSerialMergeScheduler;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.policy.EnableMergePolicy;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class SerialMergeSchedulerProvider
extends AbstractIndexShardComponent
implements MergeSchedulerProvider {
    private Set<CustomSerialMergeScheduler> schedulers = new CopyOnWriteArraySet<CustomSerialMergeScheduler>();

    @Inject
    public SerialMergeSchedulerProvider(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
        this.logger.trace("using [serial] merge scheduler", new Object[0]);
    }

    public MergeScheduler newMergeScheduler() {
        CustomSerialMergeScheduler scheduler = new CustomSerialMergeScheduler(this.logger, this);
        this.schedulers.add(scheduler);
        return scheduler;
    }

    @Override
    public MergeStats stats() {
        MergeStats mergeStats = new MergeStats();
        for (CustomSerialMergeScheduler scheduler : this.schedulers) {
            mergeStats.add(scheduler.totalMerges(), scheduler.currentMerges(), scheduler.totalMergeTime());
        }
        return mergeStats;
    }

    public static class CustomSerialMergeScheduler
    extends TrackingSerialMergeScheduler {
        private final SerialMergeSchedulerProvider provider;

        public CustomSerialMergeScheduler(ESLogger logger, SerialMergeSchedulerProvider provider) {
            super(logger);
            this.provider = provider;
        }

        @Override
        public void merge(IndexWriter writer) throws CorruptIndexException, IOException {
            try {
                if (writer.getMergePolicy() instanceof EnableMergePolicy && !((EnableMergePolicy)((Object)writer.getMergePolicy())).isMergeEnabled()) {
                    return;
                }
            }
            catch (AlreadyClosedException e) {
                return;
            }
            super.merge(writer);
        }

        @Override
        public void close() {
            super.close();
            this.provider.schedulers.remove(this);
        }
    }
}

