/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.merge.policy.EnableMergePolicy;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.store.Store;

public class LogDocMergePolicyProvider
extends AbstractIndexShardComponent
implements MergePolicyProvider<LogDocMergePolicy> {
    private final IndexSettingsService indexSettingsService;
    private volatile boolean compoundFormat;
    private volatile int minMergeDocs;
    private volatile int maxMergeDocs;
    private volatile int mergeFactor;
    private final boolean calibrateSizeByDeletes;
    private boolean asyncMerge;
    private final Set<CustomLogDocMergePolicy> policies = new CopyOnWriteArraySet<CustomLogDocMergePolicy>();
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public LogDocMergePolicyProvider(Store store, IndexSettingsService indexSettingsService) {
        super(store.shardId(), store.indexSettings());
        Preconditions.checkNotNull(store, "Store must be provided to merge policy");
        this.indexSettingsService = indexSettingsService;
        this.compoundFormat = this.indexSettings.getAsBoolean("index.compound_format", store.suggestUseCompoundFile());
        this.minMergeDocs = this.componentSettings.getAsInt("min_merge_docs", 1000);
        this.maxMergeDocs = this.componentSettings.getAsInt("max_merge_docs", Integer.MAX_VALUE);
        this.mergeFactor = this.componentSettings.getAsInt("merge_factor", 10);
        this.calibrateSizeByDeletes = this.componentSettings.getAsBoolean("calibrate_size_by_deletes", true);
        this.asyncMerge = this.indexSettings.getAsBoolean("index.merge.async", true);
        this.logger.debug("using [log_doc] merge policy with merge_factor[{}], min_merge_docs[{}], max_merge_docs[{}], calibrate_size_by_deletes[{}], async_merge[{}]", this.mergeFactor, this.minMergeDocs, this.maxMergeDocs, this.calibrateSizeByDeletes, this.asyncMerge);
        indexSettingsService.addListener(this.applySettings);
    }

    @Override
    public void close(boolean delete) throws ElasticSearchException {
        this.indexSettingsService.removeListener(this.applySettings);
    }

    @Override
    public LogDocMergePolicy newMergePolicy() {
        CustomLogDocMergePolicy mergePolicy = this.asyncMerge ? new EnableMergeLogDocMergePolicy(this) : new CustomLogDocMergePolicy(this);
        mergePolicy.setMinMergeDocs(this.minMergeDocs);
        mergePolicy.setMaxMergeDocs(this.maxMergeDocs);
        mergePolicy.setMergeFactor(this.mergeFactor);
        mergePolicy.setCalibrateSizeByDeletes(this.calibrateSizeByDeletes);
        mergePolicy.setUseCompoundFile(this.compoundFormat);
        this.policies.add(mergePolicy);
        return mergePolicy;
    }

    public static class EnableMergeLogDocMergePolicy
    extends CustomLogDocMergePolicy
    implements EnableMergePolicy {
        private final ThreadLocal<Boolean> enableMerge = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };

        public EnableMergeLogDocMergePolicy(LogDocMergePolicyProvider provider) {
            super(provider);
        }

        @Override
        public void enableMerge() {
            this.enableMerge.set(Boolean.TRUE);
        }

        @Override
        public void disableMerge() {
            this.enableMerge.set(Boolean.FALSE);
        }

        @Override
        public boolean isMergeEnabled() {
            return this.enableMerge.get() == Boolean.TRUE;
        }

        @Override
        public void close() {
            this.enableMerge.remove();
            super.close();
        }

        @Override
        public MergePolicy.MergeSpecification findMerges(SegmentInfos infos) throws IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findMerges(infos);
        }

        @Override
        public MergePolicy.MergeSpecification findMergesToExpungeDeletes(SegmentInfos segmentInfos) throws CorruptIndexException, IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findMergesToExpungeDeletes(segmentInfos);
        }

        @Override
        public MergePolicy.MergeSpecification findMergesForOptimize(SegmentInfos infos, int maxNumSegments, Set<SegmentInfo> segmentsToOptimize) throws IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findMergesForOptimize(infos, maxNumSegments, segmentsToOptimize);
        }
    }

    public static class CustomLogDocMergePolicy
    extends LogDocMergePolicy {
        private final LogDocMergePolicyProvider provider;

        public CustomLogDocMergePolicy(LogDocMergePolicyProvider provider) {
            this.provider = provider;
        }

        @Override
        public void close() {
            super.close();
            this.provider.policies.remove(this);
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            boolean compoundFormat;
            int mergeFactor;
            int maxMergeDocs;
            int minMergeDocs = settings.getAsInt("index.merge.policy.min_merge_docs", LogDocMergePolicyProvider.this.minMergeDocs);
            if (minMergeDocs != LogDocMergePolicyProvider.this.minMergeDocs) {
                LogDocMergePolicyProvider.this.logger.info("updating min_merge_docs from [{}] to [{}]", LogDocMergePolicyProvider.this.minMergeDocs, minMergeDocs);
                LogDocMergePolicyProvider.this.minMergeDocs = minMergeDocs;
                for (CustomLogDocMergePolicy policy : LogDocMergePolicyProvider.this.policies) {
                    policy.setMinMergeDocs(minMergeDocs);
                }
            }
            if ((maxMergeDocs = settings.getAsInt("index.merge.policy.max_merge_docs", LogDocMergePolicyProvider.this.maxMergeDocs).intValue()) != LogDocMergePolicyProvider.this.maxMergeDocs) {
                LogDocMergePolicyProvider.this.logger.info("updating max_merge_docs from [{}] to [{}]", LogDocMergePolicyProvider.this.maxMergeDocs, maxMergeDocs);
                LogDocMergePolicyProvider.this.maxMergeDocs = maxMergeDocs;
                for (CustomLogDocMergePolicy policy : LogDocMergePolicyProvider.this.policies) {
                    policy.setMaxMergeDocs(maxMergeDocs);
                }
            }
            if ((mergeFactor = settings.getAsInt("index.merge.policy.merge_factor", LogDocMergePolicyProvider.this.mergeFactor).intValue()) != LogDocMergePolicyProvider.this.mergeFactor) {
                LogDocMergePolicyProvider.this.logger.info("updating merge_factor from [{}] to [{}]", LogDocMergePolicyProvider.this.mergeFactor, mergeFactor);
                LogDocMergePolicyProvider.this.mergeFactor = mergeFactor;
                for (CustomLogDocMergePolicy policy : LogDocMergePolicyProvider.this.policies) {
                    policy.setMergeFactor(mergeFactor);
                }
            }
            if ((compoundFormat = settings.getAsBoolean("index.compound_format", LogDocMergePolicyProvider.this.compoundFormat).booleanValue()) != LogDocMergePolicyProvider.this.compoundFormat) {
                LogDocMergePolicyProvider.this.logger.info("updating index.compound_format from [{}] to [{}]", LogDocMergePolicyProvider.this.compoundFormat, compoundFormat);
                LogDocMergePolicyProvider.this.compoundFormat = compoundFormat;
                for (CustomLogDocMergePolicy policy : LogDocMergePolicyProvider.this.policies) {
                    policy.setUseCompoundFile(compoundFormat);
                }
            }
        }
    }
}

