/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.local;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.gateway.RecoveryStatus;
import org.elasticsearch.index.gateway.SnapshotStatus;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.FsTranslog;
import org.elasticsearch.threadpool.ThreadPool;

public class LocalIndexShardGateway
extends AbstractIndexShardComponent
implements IndexShardGateway {
    private final InternalIndexShard indexShard;
    private final RecoveryStatus recoveryStatus = new RecoveryStatus();
    private final ScheduledFuture flushScheduler;

    @Inject
    public LocalIndexShardGateway(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexShard indexShard) {
        super(shardId, indexSettings);
        this.indexShard = (InternalIndexShard)indexShard;
        TimeValue sync = this.componentSettings.getAsTime("sync", TimeValue.timeValueSeconds(1L));
        if (sync.millis() > 0L) {
            this.indexShard.translog().syncOnEachOperation(false);
            this.flushScheduler = threadPool.scheduleWithFixedDelay(new Sync(), sync);
        } else if (sync.millis() == 0L) {
            this.flushScheduler = null;
            this.indexShard.translog().syncOnEachOperation(true);
        } else {
            this.flushScheduler = null;
        }
    }

    public String toString() {
        return "local";
    }

    @Override
    public RecoveryStatus recoveryStatus() {
        return this.recoveryStatus;
    }

    @Override
    public void recover(RecoveryStatus recoveryStatus) throws IndexShardGatewayRecoveryException {
        File translogFile;
        recoveryStatus.index().startTime(System.currentTimeMillis());
        long version = -1L;
        try {
            if (IndexReader.indexExists(this.indexShard.store().directory())) {
                version = IndexReader.getCurrentVersion(this.indexShard.store().directory());
            }
        }
        catch (IOException e) {
            throw new IndexShardGatewayRecoveryException(this.shardId(), "Failed to fetch index version after copying it over", (Throwable)e);
        }
        recoveryStatus.index().updateVersion(version);
        recoveryStatus.index().time(System.currentTimeMillis() - recoveryStatus.index().startTime());
        try {
            int numberOfFiles = 0;
            long totalSizeInBytes = 0L;
            for (String name : this.indexShard.store().directory().listAll()) {
                ++numberOfFiles;
                totalSizeInBytes += this.indexShard.store().directory().fileLength(name);
            }
            recoveryStatus.index().files(numberOfFiles, totalSizeInBytes, numberOfFiles, totalSizeInBytes);
        }
        catch (Exception e) {
            // empty catch block
        }
        recoveryStatus.translog().startTime(System.currentTimeMillis());
        if (version == -1L) {
            this.indexShard.start("post recovery from gateway, no translog");
            recoveryStatus.translog().time(System.currentTimeMillis() - recoveryStatus.index().startTime());
            return;
        }
        FsTranslog translog = (FsTranslog)this.indexShard.translog();
        File recoveringTranslogFile = new File(translog.location(), "translog-" + version + ".recovering");
        if (!recoveringTranslogFile.exists() && (translogFile = new File(translog.location(), "translog-" + version)).exists()) {
            for (int i = 0; i < 3 && !translogFile.renameTo(recoveringTranslogFile); ++i) {
            }
        }
        if (!recoveringTranslogFile.exists()) {
            this.indexShard.start("post recovery from gateway, no translog");
            recoveryStatus.translog().time(System.currentTimeMillis() - recoveryStatus.index().startTime());
            return;
        }
        this.indexShard.performRecoveryPrepareForTranslog();
        try {
            InputStreamStreamInput si = new InputStreamStreamInput(new FileInputStream(recoveringTranslogFile));
            while (true) {
                Translog.Operation operation;
                try {
                    int opSize = si.readInt();
                    operation = TranslogStreams.readTranslogOperation(si);
                }
                catch (EOFException e) {
                    break;
                }
                catch (IOException e) {
                    break;
                }
                recoveryStatus.translog().addTranslogOperations(1);
                this.indexShard.performRecoveryOperation(operation);
            }
        }
        catch (Throwable e) {
            this.indexShard.translog().close(true);
            throw new IndexShardGatewayRecoveryException(this.shardId, "failed to recover shard", e);
        }
        this.indexShard.performRecoveryFinalization(true);
        recoveringTranslogFile.delete();
        recoveryStatus.translog().time(System.currentTimeMillis() - recoveryStatus.index().startTime());
    }

    @Override
    public String type() {
        return "local";
    }

    @Override
    public SnapshotStatus snapshot(IndexShardGateway.Snapshot snapshot) {
        return null;
    }

    @Override
    public SnapshotStatus lastSnapshotStatus() {
        return null;
    }

    @Override
    public SnapshotStatus currentSnapshotStatus() {
        return null;
    }

    @Override
    public boolean requiresSnapshot() {
        return false;
    }

    @Override
    public boolean requiresSnapshotScheduling() {
        return false;
    }

    @Override
    public void close(boolean delete) {
        if (this.flushScheduler != null) {
            this.flushScheduler.cancel(false);
        }
    }

    @Override
    public IndexShardGateway.SnapshotLock obtainSnapshotLock() throws Exception {
        return NO_SNAPSHOT_LOCK;
    }

    private class Sync
    implements Runnable {
        private Sync() {
        }

        @Override
        public void run() {
            if (LocalIndexShardGateway.this.indexShard.state() == IndexShardState.STARTED) {
                LocalIndexShardGateway.this.indexShard.translog().sync();
            }
        }
    }
}

