/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166y;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.LockSupport;
import org.elasticsearch.common.util.concurrent.jsr166y.ForkJoinPool;
import org.elasticsearch.common.util.concurrent.jsr166y.ForkJoinTask;
import sun.misc.Unsafe;

public class ForkJoinWorkerThread
extends Thread {
    private static final Random seedGenerator = new Random();
    private static final int MAX_HELP_DEPTH = 8;
    private static final int INITIAL_QUEUE_CAPACITY = 8192;
    private static final int MAXIMUM_QUEUE_CAPACITY;
    final ForkJoinPool pool;
    private ForkJoinTask<?>[] queue;
    private volatile int base;
    private int sp;
    private int stealHint;
    volatile int runState;
    private static final int TERMINATING = 1;
    private static final int TERMINATED = 2;
    private static final int SUSPENDED = 4;
    private static final int TRIMMED = 8;
    int stealCount;
    private int seed;
    boolean active;
    private final boolean locallyFifo;
    int poolIndex;
    int lastEventCount;
    volatile long nextWaiter;
    int spareCount;
    volatile int nextSpare;
    private volatile ForkJoinTask<?> currentJoin;
    private volatile ForkJoinTask<?> currentSteal;
    private static final Unsafe UNSAFE;
    private static final long spOffset;
    private static final long runStateOffset;
    private static final long currentJoinOffset;
    private static final long currentStealOffset;
    private static final long qBase;
    private static final long poolRunStateOffset;
    private static final int qShift;

    protected ForkJoinWorkerThread(ForkJoinPool pool) {
        this.pool = pool;
        this.locallyFifo = pool.locallyFifo;
        this.setDaemon(true);
    }

    final void start(int poolIndex, Thread.UncaughtExceptionHandler ueh) {
        this.poolIndex = poolIndex;
        if (ueh != null) {
            this.setUncaughtExceptionHandler(ueh);
        }
        this.start();
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.poolIndex;
    }

    protected void onStart() {
        int rs = seedGenerator.nextInt();
        this.seed = rs == 0 ? 1 : rs;
        String pid = Integer.toString(this.pool.getPoolNumber());
        String wid = Integer.toString(this.poolIndex);
        this.setName("ForkJoinPool-" + pid + "-worker-" + wid);
        this.queue = new ForkJoinTask[8192];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTermination(Throwable exception) {
        try {
            ForkJoinPool p = this.pool;
            if (this.active) {
                int a;
                this.active = false;
                while (!UNSAFE.compareAndSwapInt(p, poolRunStateOffset, a = p.runState, a - 1)) {
                }
            }
            this.cancelTasks();
            this.setTerminated();
            p.workerTerminated(this);
        }
        catch (Throwable ex) {
            if (exception == null) {
                exception = ex;
            }
        }
        finally {
            if (exception != null) {
                UNSAFE.throwException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable exception = null;
        try {
            this.onStart();
            this.mainLoop();
        }
        catch (Throwable ex) {
            exception = ex;
        }
        finally {
            this.onTermination(exception);
        }
    }

    private void mainLoop() {
        boolean ran = false;
        ForkJoinPool p = this.pool;
        while (true) {
            p.preStep(this, ran);
            if (this.runState != 0) break;
            ran = this.tryExecSteal() || this.tryExecSubmission();
        }
    }

    private boolean tryExecSteal() {
        ForkJoinTask<?> t = this.scan();
        if (t != null) {
            t.quietlyExec();
            UNSAFE.putOrderedObject(this, currentStealOffset, null);
            if (this.sp != this.base) {
                this.execLocalTasks();
            }
            return true;
        }
        return false;
    }

    private boolean tryExecSubmission() {
        ForkJoinPool p = this.pool;
        while (p.hasQueuedSubmissions()) {
            ForkJoinTask<?> t;
            int a;
            if (!this.active && !(this.active = UNSAFE.compareAndSwapInt(p, poolRunStateOffset, a = p.runState, a + 1)) || (t = p.pollSubmission()) == null) continue;
            UNSAFE.putOrderedObject(this, currentStealOffset, t);
            t.quietlyExec();
            UNSAFE.putOrderedObject(this, currentStealOffset, null);
            if (this.sp != this.base) {
                this.execLocalTasks();
            }
            return true;
        }
        return false;
    }

    private void execLocalTasks() {
        while (this.runState == 0) {
            ForkJoinTask<?> t;
            ForkJoinTask<?> forkJoinTask = t = this.locallyFifo ? this.locallyDeqTask() : this.popTask();
            if (t != null) {
                t.quietlyExec();
                continue;
            }
            if (this.sp != this.base) continue;
            break;
        }
    }

    private static final boolean casSlotNull(ForkJoinTask<?>[] q, int i, ForkJoinTask<?> t) {
        return UNSAFE.compareAndSwapObject(q, (long)(i << qShift) + qBase, t, null);
    }

    private static final void writeSlot(ForkJoinTask<?>[] q, int i, ForkJoinTask<?> t) {
        UNSAFE.putObjectVolatile(q, (long)(i << qShift) + qBase, t);
    }

    final void pushTask(ForkJoinTask<?> t) {
        ForkJoinTask<?>[] q = this.queue;
        int mask = q.length - 1;
        int s = this.sp++;
        UNSAFE.putOrderedObject(q, (long)((s & mask) << qShift) + qBase, t);
        if ((s -= this.base) == 0) {
            this.pool.signalWork();
        } else if (s == mask) {
            this.growQueue();
        }
    }

    final ForkJoinTask<?> deqTask() {
        int b = this.base;
        if (this.sp != b) {
            int i;
            ForkJoinTask<?> t;
            ForkJoinTask<?>[] q = this.queue;
            if (this.queue != null && (t = q[i = q.length - 1 & b]) != null && this.base == b && UNSAFE.compareAndSwapObject(q, (long)(i << qShift) + qBase, t, null)) {
                this.base = b + 1;
                return t;
            }
        }
        return null;
    }

    final ForkJoinTask<?> locallyDeqTask() {
        ForkJoinTask<?>[] q = this.queue;
        if (q != null) {
            int b;
            while (this.sp != (b = this.base)) {
                int i = q.length - 1 & b;
                ForkJoinTask<?> t = q[i];
                if (t == null || this.base != b || !UNSAFE.compareAndSwapObject(q, (long)(i << qShift) + qBase, t, null)) continue;
                this.base = b + 1;
                return t;
            }
        }
        return null;
    }

    private ForkJoinTask<?> popTask() {
        ForkJoinTask<?>[] q = this.queue;
        if (q != null) {
            int s;
            while ((s = this.sp) != this.base) {
                int i = q.length - 1 & --s;
                long u = (long)(i << qShift) + qBase;
                ForkJoinTask<?> t = q[i];
                if (t == null) break;
                if (!UNSAFE.compareAndSwapObject(q, u, t, null)) continue;
                this.sp = s;
                return t;
            }
        }
        return null;
    }

    final boolean unpushTask(ForkJoinTask<?> t) {
        ForkJoinTask<?>[] q = this.queue;
        int s = this.sp;
        if (s != this.base && q != null && UNSAFE.compareAndSwapObject(q, (long)((q.length - 1 & --s) << qShift) + qBase, t, null)) {
            this.sp = s;
            return true;
        }
        return false;
    }

    final ForkJoinTask<?> peekTask() {
        ForkJoinTask<?>[] q = this.queue;
        if (q == null) {
            return null;
        }
        int mask = q.length - 1;
        int i = this.locallyFifo ? this.base : this.sp - 1;
        return q[i & mask];
    }

    private void growQueue() {
        ForkJoinTask<?>[] oldQ = this.queue;
        int oldSize = oldQ.length;
        int newSize = oldSize << 1;
        if (newSize > MAXIMUM_QUEUE_CAPACITY) {
            throw new RejectedExecutionException("Queue capacity exceeded");
        }
        this.queue = new ForkJoinTask[newSize];
        ForkJoinTask[] newQ = this.queue;
        int b = this.base;
        int bf = b + oldSize;
        int oldMask = oldSize - 1;
        int newMask = newSize - 1;
        do {
            int oldIndex;
            ForkJoinTask<?> t;
            if ((t = oldQ[oldIndex = b & oldMask]) != null && !ForkJoinWorkerThread.casSlotNull(oldQ, oldIndex, t)) {
                t = null;
            }
            ForkJoinWorkerThread.writeSlot(newQ, b & newMask, t);
        } while (++b != bf);
        this.pool.signalWork();
    }

    private static final int xorShift(int r) {
        r ^= r << 13;
        r ^= r >>> 17;
        return r ^ r << 5;
    }

    private ForkJoinTask<?> scan() {
        int n;
        ForkJoinPool p = this.pool;
        ForkJoinWorkerThread[] ws = p.workers;
        if (p.workers != null && (n = ws.length) > 1) {
            boolean canSteal = this.active;
            int r = this.seed;
            int mask = n - 1;
            int j = -n;
            int k = r;
            while (true) {
                int b;
                ForkJoinWorkerThread v = ws[k & mask];
                r ^= r << 13;
                r ^= r >>> 17;
                r ^= r << 5;
                if (v != null && (b = v.base) != v.sp) {
                    ForkJoinTask<?>[] q = v.queue;
                    if (v.queue != null) {
                        int i = q.length - 1 & b;
                        long u = (long)(i << qShift) + qBase;
                        int pid = this.poolIndex;
                        ForkJoinTask<?> t = q[i];
                        if (t != null) {
                            int a;
                            if (!canSteal && UNSAFE.compareAndSwapInt(p, poolRunStateOffset, a = p.runState, a + 1)) {
                                this.active = true;
                                canSteal = true;
                            }
                            if (canSteal && v.base == b++ && UNSAFE.compareAndSwapObject(q, u, t, null)) {
                                v.base = b;
                                v.stealHint = pid;
                                UNSAFE.putOrderedObject(this, currentStealOffset, t);
                                this.seed = r;
                                ++this.stealCount;
                                return t;
                            }
                        }
                        j = -n;
                        k = r;
                        continue;
                    }
                }
                if (++j <= 0) {
                    k = r;
                    continue;
                }
                if (j > n) break;
                k += n >>> 1 | 1;
            }
        }
        return null;
    }

    final boolean isRunning() {
        return this.runState == 0;
    }

    final boolean isTerminated() {
        return (this.runState & 2) != 0;
    }

    final boolean isSuspended() {
        return (this.runState & 4) != 0;
    }

    final boolean isTrimmed() {
        return (this.runState & 8) != 0;
    }

    final boolean isTerminating() {
        if ((this.runState & 1) != 0) {
            return true;
        }
        if (this.pool.isAtLeastTerminating()) {
            this.shutdown();
            return true;
        }
        return false;
    }

    final void shutdown() {
        int s;
        while (((s = this.runState) & 3) == 0 && !((s & 4) != 0 ? UNSAFE.compareAndSwapInt(this, runStateOffset, s, s & 0xFFFFFFFB | 9) : UNSAFE.compareAndSwapInt(this, runStateOffset, s, s | 1))) {
        }
    }

    private void setTerminated() {
        int s;
        while (!UNSAFE.compareAndSwapInt(this, runStateOffset, s = this.runState, s | 3)) {
        }
    }

    final boolean tryUnsuspend() {
        int s;
        while (((s = this.runState) & 4) != 0) {
            if (!UNSAFE.compareAndSwapInt(this, runStateOffset, s, s & 0xFFFFFFFB)) continue;
            return true;
        }
        return false;
    }

    final void suspendAsSpare() {
        while (true) {
            int s;
            if (((s = this.runState) & 1) != 0) {
                if (!UNSAFE.compareAndSwapInt(this, runStateOffset, s, s | 9)) continue;
                return;
            }
            if (UNSAFE.compareAndSwapInt(this, runStateOffset, s, s | 4)) break;
        }
        ForkJoinPool p = this.pool;
        p.pushSpare(this);
        while ((this.runState & 4) != 0) {
            if (!p.tryAccumulateStealCount(this)) continue;
            ForkJoinWorkerThread.interrupted();
            if ((this.runState & 4) == 0) break;
            LockSupport.park(this);
        }
    }

    final int getQueueSize() {
        int n = -this.base + this.sp;
        return n <= 0 ? 0 : n;
    }

    final void cancelTasks() {
        ForkJoinTask<?> cs;
        ForkJoinTask<?> cj = this.currentJoin;
        if (cj != null && cj.status >= 0) {
            cj.cancelIgnoringExceptions();
            try {
                this.interrupt();
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
        }
        if ((cs = this.currentSteal) != null && cs.status >= 0) {
            cs.cancelIgnoringExceptions();
        }
        while (this.base != this.sp) {
            ForkJoinTask<?> t = this.deqTask();
            if (t == null) continue;
            t.cancelIgnoringExceptions();
        }
    }

    final int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        int n = 0;
        while (this.base != this.sp) {
            ForkJoinTask<?> t = this.deqTask();
            if (t == null) continue;
            c.add(t);
            ++n;
        }
        return n;
    }

    final ForkJoinTask<?> pollLocalTask() {
        ForkJoinPool p = this.pool;
        while (this.sp != this.base) {
            int a;
            if (!this.active && !(this.active = UNSAFE.compareAndSwapInt(p, poolRunStateOffset, a = p.runState, a + 1))) continue;
            return this.locallyFifo ? this.locallyDeqTask() : this.popTask();
        }
        return null;
    }

    final ForkJoinTask<?> pollTask() {
        ForkJoinTask<?> t = this.pollLocalTask();
        if (t == null) {
            t = this.scan();
            UNSAFE.putOrderedObject(this, currentStealOffset, null);
        }
        return t;
    }

    final void joinTask(ForkJoinTask<?> joinMe, boolean timed, long nanos) {
        ForkJoinTask<?> prevJoin = this.currentJoin;
        UNSAFE.putOrderedObject(this, currentJoinOffset, joinMe);
        this.pool.awaitJoin(joinMe, this, timed, nanos);
        UNSAFE.putOrderedObject(this, currentJoinOffset, prevJoin);
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean helpJoinTask(ForkJoinTask<?> joinMe, boolean running) {
        ForkJoinWorkerThread[] ws;
        ForkJoinPool p = this.pool;
        while (true) {
            if (joinMe.status < 0) {
                return running;
            }
            if ((this.runState & 1) != 0) {
                joinMe.cancelIgnoringExceptions();
                return running;
            }
            int s = this.sp;
            if (s == this.base) break;
            ForkJoinTask<?>[] q = this.queue;
            if (this.queue == null) break;
            int i = q.length - 1 & --s;
            long u = (long)(i << qShift) + qBase;
            ForkJoinTask<?> t = q[i];
            if (t == null) break;
            if (t != joinMe && t.status >= 0) {
                return running;
            }
            if (!running && !(running = p.tryIncrementRunningCount()) || !UNSAFE.compareAndSwapObject(q, u, t, null)) continue;
            this.sp = s;
            t.quietlyExec();
        }
        if ((ws = p.workers) == null) return running;
        int n = ws.length;
        if (n <= 1) return running;
        ForkJoinTask<?> task = joinMe;
        ForkJoinWorkerThread thread = this;
        int d = 0;
        while (d < 8) {
            ForkJoinWorkerThread v;
            block18: {
                block17: {
                    v = ws[thread.stealHint & n - 1];
                    if (v == null || v.currentSteal != task) {
                        int j = 0;
                        while (j < n) {
                            ForkJoinTask<?> vs;
                            v = ws[j];
                            if (v != null && (vs = v.currentSteal) != null) {
                                if (joinMe.status < 0) {
                                    return running;
                                }
                                if (vs == task) {
                                    if (task.status < 0) {
                                        return running;
                                    }
                                    thread.stealHint = j;
                                    break block17;
                                }
                            }
                            ++j;
                        }
                        break block1;
                        return running;
                    }
                }
                while (true) {
                    if (joinMe.status < 0) {
                        return running;
                    }
                    int b = v.base;
                    ForkJoinTask<?>[] q = v.queue;
                    if (b == v.sp || q == null) break block18;
                    int i = q.length - 1 & b;
                    long u = (long)(i << qShift) + qBase;
                    ForkJoinTask<?> t = q[i];
                    if (task.status < 0) {
                        return running;
                    }
                    if (t != null && (running || (running = p.tryIncrementRunningCount())) && v.base == b++ && UNSAFE.compareAndSwapObject(q, u, t, null)) {
                        int pid;
                        if (t != joinMe && joinMe.status < 0) {
                            UNSAFE.putObjectVolatile(q, u, t);
                            return running;
                        }
                        v.base = b;
                        if (t.status < 0) continue;
                        ForkJoinTask<?> ps = this.currentSteal;
                        v.stealHint = pid = this.poolIndex;
                        UNSAFE.putOrderedObject(this, currentStealOffset, t);
                        t.quietlyExec();
                        UNSAFE.putOrderedObject(this, currentStealOffset, ps);
                        continue;
                    }
                    if ((this.runState & 1) != 0) break;
                }
                joinMe.cancelIgnoringExceptions();
                return running;
            }
            ForkJoinTask<?> next = v.currentJoin;
            if (task.status < 0) return running;
            if (next == null) return running;
            if (next == task) return running;
            if (joinMe.status < 0) {
                return running;
            }
            task = next;
            thread = v;
            ++d;
        }
        return running;
    }

    final int getEstimatedSurplusTaskCount() {
        return this.sp - this.base - this.pool.idlePerActive();
    }

    final void helpQuiescePool() {
        int a;
        ForkJoinPool p;
        ForkJoinTask<?> ps = this.currentSteal;
        while (true) {
            ForkJoinTask<?> t;
            if ((t = this.pollLocalTask()) != null || (t = this.scan()) != null) {
                t.quietlyExec();
                continue;
            }
            p = this.pool;
            if (this.active) {
                a = p.runState;
                if (!UNSAFE.compareAndSwapInt(p, poolRunStateOffset, a, a - 1)) continue;
                this.active = false;
                UNSAFE.putOrderedObject(this, currentStealOffset, ps);
            }
            if (p.isQuiescent()) break;
        }
        this.active = true;
        while (!UNSAFE.compareAndSwapInt(p, poolRunStateOffset, a = p.runState, a + 1)) {
        }
    }

    private static long objectFieldOffset(String field, Class<?> klazz) {
        try {
            return UNSAFE.objectFieldOffset(klazz.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldError error = new NoSuchFieldError(field);
            error.initCause(e);
            throw error;
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        UNSAFE = ForkJoinWorkerThread.getUnsafe();
        spOffset = ForkJoinWorkerThread.objectFieldOffset("sp", ForkJoinWorkerThread.class);
        runStateOffset = ForkJoinWorkerThread.objectFieldOffset("runState", ForkJoinWorkerThread.class);
        currentJoinOffset = ForkJoinWorkerThread.objectFieldOffset("currentJoin", ForkJoinWorkerThread.class);
        currentStealOffset = ForkJoinWorkerThread.objectFieldOffset("currentSteal", ForkJoinWorkerThread.class);
        qBase = UNSAFE.arrayBaseOffset(ForkJoinTask[].class);
        poolRunStateOffset = ForkJoinWorkerThread.objectFieldOffset("runState", ForkJoinPool.class);
        int s = UNSAFE.arrayIndexScale(ForkJoinTask[].class);
        if ((s & s - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        qShift = 31 - Integer.numberOfLeadingZeros(s);
        MAXIMUM_QUEUE_CAPACITY = 1 << 31 - qShift;
    }
}

