/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.thread;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.thread.ThreadNameDeterminer;

public class ThreadRenamingRunnable
implements Runnable {
    private static final ESLogger logger = Loggers.getLogger(ThreadRenamingRunnable.class);
    private static volatile ThreadNameDeterminer threadNameDeterminer = ThreadNameDeterminer.PROPOSED;
    private final Runnable runnable;
    private final String proposedThreadName;

    public static ThreadNameDeterminer getThreadNameDeterminer() {
        return threadNameDeterminer;
    }

    public static void setThreadNameDeterminer(ThreadNameDeterminer threadNameDeterminer) {
        if (threadNameDeterminer == null) {
            throw new NullPointerException("threadNameDeterminer");
        }
        ThreadRenamingRunnable.threadNameDeterminer = threadNameDeterminer;
    }

    public ThreadRenamingRunnable(Runnable runnable, String proposedThreadName) {
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        if (proposedThreadName == null) {
            throw new NullPointerException("proposedThreadName");
        }
        this.runnable = runnable;
        this.proposedThreadName = proposedThreadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        String oldThreadName = currentThread.getName();
        String newThreadName = this.getNewThreadName(oldThreadName);
        boolean renamed = false;
        if (!oldThreadName.equals(newThreadName)) {
            try {
                currentThread.setName(newThreadName);
                renamed = true;
            }
            catch (SecurityException e) {
                logger.debug("Failed to rename a thread due to security restriction.", e, new Object[0]);
            }
        }
        try {
            this.runnable.run();
        }
        finally {
            if (renamed) {
                currentThread.setName(oldThreadName);
            }
        }
    }

    private String getNewThreadName(String currentThreadName) {
        String newThreadName = null;
        try {
            newThreadName = ThreadRenamingRunnable.getThreadNameDeterminer().determineThreadName(currentThreadName, this.proposedThreadName);
        }
        catch (Throwable t) {
            logger.warn("Failed to determine the thread name", t, new Object[0]);
        }
        return newThreadName == null ? currentThreadName : newThreadName;
    }
}

