/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging.jdk;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.common.logging.support.AbstractESLogger;

public class JdkESLogger
extends AbstractESLogger {
    private final Logger logger;
    private final String name;

    public JdkESLogger(String prefix, String name, Logger logger) {
        super(prefix);
        this.logger = logger;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    protected void internalTrace(String msg) {
        this.logger.logp(Level.FINEST, this.name, null, msg);
    }

    @Override
    protected void internalTrace(String msg, Throwable cause) {
        this.logger.logp(Level.FINEST, this.name, null, msg, cause);
    }

    @Override
    protected void internalDebug(String msg) {
        this.logger.logp(Level.FINE, this.name, null, msg);
    }

    @Override
    protected void internalDebug(String msg, Throwable cause) {
        this.logger.logp(Level.FINE, this.name, null, msg, cause);
    }

    @Override
    protected void internalInfo(String msg) {
        this.logger.logp(Level.INFO, this.name, null, msg);
    }

    @Override
    protected void internalInfo(String msg, Throwable cause) {
        this.logger.logp(Level.INFO, this.name, null, msg, cause);
    }

    @Override
    protected void internalWarn(String msg) {
        this.logger.logp(Level.WARNING, this.name, null, msg);
    }

    @Override
    protected void internalWarn(String msg, Throwable cause) {
        this.logger.logp(Level.WARNING, this.name, null, msg, cause);
    }

    @Override
    protected void internalError(String msg) {
        this.logger.logp(Level.SEVERE, this.name, null, msg);
    }

    @Override
    protected void internalError(String msg, Throwable cause) {
        this.logger.logp(Level.SEVERE, this.name, null, msg, cause);
    }
}

