/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.common.compress.lzf.BufferRecycler;
import org.elasticsearch.common.compress.lzf.ChunkEncoder;

public class LZFOutputStream
extends OutputStream {
    private static int OUTPUT_BUFFER_SIZE = 65535;
    private final ChunkEncoder _encoder = new ChunkEncoder(OUTPUT_BUFFER_SIZE);
    private final BufferRecycler _recycler = BufferRecycler.instance();
    protected final OutputStream _outputStream;
    protected byte[] _outputBuffer;
    protected int _position = 0;

    public LZFOutputStream(OutputStream outputStream) {
        this._outputStream = outputStream;
        this._outputBuffer = this._recycler.allocOutputBuffer(OUTPUT_BUFFER_SIZE);
    }

    @Override
    public void write(int singleByte) throws IOException {
        if (this._position >= this._outputBuffer.length) {
            this.writeCompressedBlock();
        }
        this._outputBuffer[this._position++] = (byte)singleByte;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        int BUFFER_LEN = this._outputBuffer.length;
        int free = BUFFER_LEN - this._position;
        if (free >= length) {
            System.arraycopy(buffer, offset, this._outputBuffer, this._position, length);
            this._position += length;
            return;
        }
        System.arraycopy(buffer, offset, this._outputBuffer, this._position, free);
        offset += free;
        length -= free;
        this._position += free;
        this.writeCompressedBlock();
        while (length >= BUFFER_LEN) {
            this._encoder.encodeAndWriteChunk(buffer, offset, BUFFER_LEN, this._outputStream);
            offset += BUFFER_LEN;
            length -= BUFFER_LEN;
        }
        if (length > 0) {
            System.arraycopy(buffer, offset, this._outputBuffer, 0, length);
        }
        this._position = length;
    }

    @Override
    public void flush() throws IOException {
        if (this._position > 0) {
            this.writeCompressedBlock();
        }
        this._outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this._outputStream.close();
        this._encoder.close();
        byte[] buf = this._outputBuffer;
        if (buf != null) {
            this._outputBuffer = null;
            this._recycler.releaseOutputBuffer(buf);
        }
    }

    private void writeCompressedBlock() throws IOException {
        int chunkLen;
        int left = this._position;
        this._position = 0;
        int offset = 0;
        do {
            chunkLen = Math.min(65535, left);
            this._encoder.encodeAndWriteChunk(this._outputBuffer, 0, chunkLen, this._outputStream);
            offset += chunkLen;
        } while ((left -= chunkLen) > 0);
    }
}

