/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.HashSet;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.InvalidAliasNameException;

public class MetaDataIndexAliasesService
extends AbstractComponent {
    private final ClusterService clusterService;

    @Inject
    public MetaDataIndexAliasesService(Settings settings, ClusterService clusterService) {
        super(settings);
        this.clusterService = clusterService;
    }

    public void indicesAliases(final Request request, final Listener listener) {
        this.clusterService.submitStateUpdateTask("index-aliases", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                for (AliasAction aliasAction : request.actions) {
                    if (!currentState.metaData().hasIndex(aliasAction.index())) {
                        listener.onFailure(new IndexMissingException(new Index(aliasAction.index())));
                        return currentState;
                    }
                    if (!currentState.metaData().hasIndex(aliasAction.alias())) continue;
                    listener.onFailure(new InvalidAliasNameException(new Index(aliasAction.index()), aliasAction.alias(), "an index exists with the same name as the alias"));
                    return currentState;
                }
                MetaData.Builder builder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                for (AliasAction aliasAction : request.actions) {
                    IndexMetaData indexMetaData = builder.get(aliasAction.index());
                    if (indexMetaData == null) {
                        throw new IndexMissingException(new Index(aliasAction.index()));
                    }
                    HashSet<String> indexAliases = Sets.newHashSet(indexMetaData.settings().getAsArray("index.aliases"));
                    if (aliasAction.actionType() == AliasAction.Type.ADD) {
                        indexAliases.add(aliasAction.alias());
                    } else if (aliasAction.actionType() == AliasAction.Type.REMOVE) {
                        indexAliases.remove(aliasAction.alias());
                    }
                    Settings settings = ImmutableSettings.settingsBuilder().put(indexMetaData.settings()).putArray("index.aliases", indexAliases.toArray(new String[indexAliases.size()])).build();
                    builder.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).settings(settings));
                }
                return ClusterState.newClusterStateBuilder().state(currentState).metaData(builder).build();
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                listener.onResponse(new Response());
            }
        });
    }

    public static class Response {
    }

    public static class Request {
        final AliasAction[] actions;

        public Request(AliasAction[] actions) {
            this.actions = actions;
        }
    }

    public static interface Listener {
        public void onResponse(Response var1);

        public void onFailure(Throwable var1);
    }
}

