/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class AliasAction
implements Streamable {
    private Type actionType;
    private String index;
    private String alias;

    private AliasAction() {
    }

    public AliasAction(Type actionType, String index, String alias) {
        this.actionType = actionType;
        this.index = index;
        this.alias = alias;
    }

    public Type actionType() {
        return this.actionType;
    }

    public String index() {
        return this.index;
    }

    public String alias() {
        return this.alias;
    }

    public static AliasAction readAliasAction(StreamInput in) throws IOException {
        AliasAction aliasAction = new AliasAction();
        aliasAction.readFrom(in);
        return aliasAction;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.actionType = Type.fromValue(in.readByte());
        this.index = in.readUTF();
        this.alias = in.readUTF();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.actionType.value());
        out.writeUTF(this.index);
        out.writeUTF(this.alias);
    }

    public static enum Type {
        ADD(0),
        REMOVE(1);

        private final byte value;

        private Type(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public static Type fromValue(byte value) {
            if (value == 0) {
                return ADD;
            }
            if (value == 1) {
                return REMOVE;
            }
            throw new ElasticSearchIllegalArgumentException("No type for action [" + value + "]");
        }
    }
}

