/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class NodesInfoResponse
extends NodesOperationResponse<NodeInfo> {
    public NodesInfoResponse() {
    }

    public NodesInfoResponse(ClusterName clusterName, NodeInfo[] nodes) {
        super(clusterName, (NodeOperationResponse[])nodes);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodes = new NodeInfo[in.readVInt()];
        for (int i = 0; i < ((NodeInfo[])this.nodes).length; ++i) {
            ((NodeInfo[])this.nodes)[i] = NodeInfo.readNodeInfo(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(((NodeInfo[])this.nodes).length);
        for (NodeInfo node : (NodeInfo[])this.nodes) {
            node.writeTo(out);
        }
    }
}

