/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class TransportStats
implements Streamable,
Serializable,
ToXContent {
    private long rxCount;
    private long rxSize;
    private long txCount;
    private long txSize;

    TransportStats() {
    }

    public TransportStats(long rxCount, long rxSize, long txCount, long txSize) {
        this.rxCount = rxCount;
        this.rxSize = rxSize;
        this.txCount = txCount;
        this.txSize = txSize;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("transport");
        builder.field("rx_count", this.rxCount);
        builder.field("rx_size", this.rxSize().toString());
        builder.field("rx_size_in_bytes", this.rxSize);
        builder.field("tx_count", this.txCount);
        builder.field("tx_size", this.txSize().toString());
        builder.field("tx_size_in_bytes", this.txSize);
        builder.endObject();
        return builder;
    }

    public static TransportStats readTransportStats(StreamInput in) throws IOException {
        TransportStats stats = new TransportStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.rxCount = in.readVLong();
        this.rxSize = in.readVLong();
        this.txCount = in.readVLong();
        this.txSize = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.rxCount);
        out.writeVLong(this.rxSize);
        out.writeVLong(this.txCount);
        out.writeVLong(this.txSize);
    }

    public long rxCount() {
        return this.rxCount;
    }

    public long getRxCount() {
        return this.rxCount();
    }

    public ByteSizeValue rxSize() {
        return new ByteSizeValue(this.rxSize);
    }

    public ByteSizeValue getRxSize() {
        return this.rxSize();
    }

    public long txCount() {
        return this.txCount;
    }

    public long getTxCount() {
        return this.txCount();
    }

    public ByteSizeValue txSize() {
        return new ByteSizeValue(this.txSize);
    }

    public ByteSizeValue getTxSize() {
        return this.txSize();
    }
}

