/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.SearchHitField;

public class InternalSearchHitField
implements SearchHitField {
    private String name;
    private List<Object> values;

    private InternalSearchHitField() {
    }

    public InternalSearchHitField(String name, List<Object> values) {
        this.name = name;
        this.values = values;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Object value() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    @Override
    public Object getValue() {
        return this.value();
    }

    @Override
    public List<Object> values() {
        return this.values;
    }

    @Override
    public List<Object> getValues() {
        return this.values();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public static InternalSearchHitField readSearchHitField(StreamInput in) throws IOException {
        InternalSearchHitField result = new InternalSearchHitField();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        int size = in.readVInt();
        this.values = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            this.values.add(Lucene.readFieldValue(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeVInt(this.values.size());
        for (Object value : this.values) {
            Lucene.writeFieldValue(out, value);
        }
    }
}

