/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResultProvider;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;

public class QueryFetchSearchResult
implements Streamable,
QuerySearchResultProvider,
FetchSearchResultProvider {
    private QuerySearchResult queryResult;
    private FetchSearchResult fetchResult;

    public QueryFetchSearchResult() {
    }

    public QueryFetchSearchResult(QuerySearchResult queryResult, FetchSearchResult fetchResult) {
        this.queryResult = queryResult;
        this.fetchResult = fetchResult;
    }

    @Override
    public long id() {
        return this.queryResult.id();
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.queryResult.shardTarget();
    }

    @Override
    public void shardTarget(SearchShardTarget shardTarget) {
        this.queryResult.shardTarget(shardTarget);
        this.fetchResult.shardTarget(shardTarget);
    }

    @Override
    public boolean includeFetch() {
        return true;
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    public static QueryFetchSearchResult readQueryFetchSearchResult(StreamInput in) throws IOException {
        QueryFetchSearchResult result = new QueryFetchSearchResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.queryResult = QuerySearchResult.readQuerySearchResult(in);
        this.fetchResult = FetchSearchResult.readFetchSearchResult(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.queryResult.writeTo(out);
        this.fetchResult.writeTo(out);
    }
}

