/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.XContentFilterBuilder;

public abstract class AbstractFacetBuilder
implements ToXContent {
    protected final String name;
    protected String scope;
    protected XContentFilterBuilder facetFilter;

    protected AbstractFacetBuilder(String name) {
        this.name = name;
    }

    public AbstractFacetBuilder facetFilter(XContentFilterBuilder filter) {
        this.facetFilter = filter;
        return this;
    }

    public AbstractFacetBuilder global(boolean global) {
        this.scope = "_global_";
        return this;
    }

    public AbstractFacetBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    protected void addFilterFacetAndGlobal(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.facetFilter != null) {
            builder.field("facet_filter");
            this.facetFilter.toXContent(builder, params);
        }
        if (this.scope != null) {
            builder.field("scope", this.scope);
        }
    }
}

